/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.validation;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.scoping.IMetamodelProvider;
import org.eclipse.viatra.query.patternlanguage.emf.validation.EMFPatternLanguageJavaValidator;
import org.eclipse.viatra.query.tooling.core.generator.genmodel.IVQGenmodelProvider;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class GenmodelBasedEMFPatternLanguageJavaValidator
extends EMFPatternLanguageJavaValidator {
    @Inject
    private IVQGenmodelProvider genmodelProvider;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private Logger logger;
    @Inject
    private IMetamodelProvider metamodelProvider;
    @Inject
    private TypeReferences typeReferences;

    @Deprecated
    public void checkPackageDeclaration(PatternModel model) {
    }

    @Deprecated
    protected String getActualPackageName(PatternModel model) {
        return null;
    }

    @Check
    public void checkImportDependency(PackageImport importDecl) {
        GenModel genmodel;
        Resource res = importDecl.eResource();
        if (this.projectProvider == null || res == null) {
            return;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(res.getResourceSet());
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        GenPackage genPackage = this.genmodelProvider.findGenPackage((EObject)importDecl, importDecl.getEPackage());
        if (genPackage != null && (genmodel = genPackage.getGenModel()) != null) {
            String modelPluginID = genmodel.getModelPluginID();
            try {
                if (!(modelPluginID == null || modelPluginID.isEmpty() || modelPluginID.equals(project.getName()) || ProjectGenerationHelper.checkBundleDependency((IProject)project, (String)modelPluginID))) {
                    this.warning(String.format("To refer elements from the Package %s the bundle %s must be added as dependency", importDecl.getEPackage().getNsURI(), modelPluginID), (EObject)importDecl, (EStructuralFeature)EMFPatternLanguagePackage.Literals.PACKAGE_IMPORT__EPACKAGE, "org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.missing_import_dependency", new String[]{modelPluginID});
                }
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error while checking the dependencies of the import declaration", (Throwable)e);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkClassPath(ClassType typeDecl) {
        Resource resource = typeDecl.eResource();
        if (resource == null || resource.getResourceSet() == null) {
            return;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(resource.getResourceSet());
        if (javaProject == null) {
            return;
        }
        EClassifier classifier = typeDecl.getClassname();
        String clazz = this.metamodelProvider.getQualifiedClassName(classifier, (EObject)classifier);
        if (clazz != null && !clazz.isEmpty() && this.typeReferences.findDeclaredType(clazz, (Notifier)typeDecl) == null) {
            this.error(String.format("Couldn't find type %s on the project's classpath", clazz), (EObject)typeDecl, null, "org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes.type_not_on_classpath", new String[]{classifier.getEPackage().getNsURI()});
        }
    }
}

