/**
 * Copyright (c) 2010-2015, Denes Harmath, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Denes Harmath - initial API and implementation
 */
package org.eclipse.viatra.query.patternlanguage.validation.whitelist;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.patternlanguage.validation.whitelist.PureWhitelist;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * Checks whether a {@link JvmOperation} is pure.
 */
@SuppressWarnings("all")
public class PurityChecker {
  public static boolean isPure(final JvmOperation jvmOperation) {
    return (PurityChecker.hasPureAnnotation(jvmOperation) || PureWhitelist.INSTANCE.contains(jvmOperation));
  }
  
  public static boolean hasPureAnnotation(final JvmOperation jvmOperation) {
    EList<JvmAnnotationReference> _annotations = jvmOperation.getAnnotations();
    final Function1<JvmAnnotationReference, Boolean> _function = new Function1<JvmAnnotationReference, Boolean>() {
      @Override
      public Boolean apply(final JvmAnnotationReference it) {
        JvmAnnotationType _annotation = it.getAnnotation();
        String _qualifiedName = _annotation.getQualifiedName();
        String _name = Pure.class.getName();
        return Boolean.valueOf(Objects.equal(_qualifiedName, _name));
      }
    };
    return IterableExtensions.<JvmAnnotationReference>exists(_annotations, _function);
  }
}
