/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc;

import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;

public class SCCResult<V> {
    private Set<Set<V>> sccs;
    private IGraphDataSource<V> gds;

    public SCCResult(Set<Set<V>> sccs, IGraphDataSource<V> gds) {
        this.sccs = sccs;
        this.gds = gds;
    }

    public Set<Set<V>> getSccs() {
        return this.sccs;
    }

    public int getSCCCount() {
        return this.sccs.size();
    }

    public double getAverageNodeCount() {
        double a = 0.0;
        for (Set<V> s : this.sccs) {
            a += (double)s.size();
        }
        return a / (double)this.sccs.size();
    }

    public double getAverageEdgeCount() {
        long edgeSum = 0L;
        for (Set<V> scc : this.sccs) {
            for (V source : scc) {
                for (V target : this.gds.getTargetNodes(source)) {
                    if (!scc.contains(target)) continue;
                    ++edgeSum;
                }
            }
        }
        return (double)edgeSum / (double)this.sccs.size();
    }

    public int getBiggestSCCSize() {
        int max = 0;
        for (Set<V> scc : this.sccs) {
            if (scc.size() <= max) continue;
            max = scc.size();
        }
        return max;
    }

    public long getSumOfSquares() {
        long sum = 0L;
        for (Set<V> scc : this.sccs) {
            sum += (long)(scc.size() * scc.size());
        }
        return sum;
    }
}

