/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.graphimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;

public class Graph<V>
implements IGraphDataSource<V>,
IBiDirectionalGraphDataSource<V> {
    private static final long serialVersionUID = 1L;
    private Map<V, List<V>> edgeList = new HashMap<V, List<V>>();
    private Map<V, List<V>> edgeListReversed = new HashMap<V, List<V>>();
    private List<IGraphObserver<V>> observers = new ArrayList<IGraphObserver<V>>();

    public void insertEdge(V source, V target) {
        List<V> outgoingEdges = this.edgeList.get(source);
        if (outgoingEdges == null) {
            outgoingEdges = new ArrayList<V>();
            outgoingEdges.add(target);
            this.edgeList.put((List<V>)source, (List<List<V>>)outgoingEdges);
        } else {
            outgoingEdges.add(target);
        }
        List<V> incomingEdges = this.edgeListReversed.get(target);
        if (incomingEdges == null) {
            incomingEdges = new ArrayList<V>();
            incomingEdges.add(source);
            this.edgeListReversed.put((List<V>)target, (List<List<V>>)incomingEdges);
        } else {
            incomingEdges.add(source);
        }
        for (IGraphObserver<V> go : this.observers) {
            go.edgeInserted(source, target);
        }
    }

    public void deleteEdge(V source, V target) {
        List<V> outgoingEdges;
        boolean containedEdge = false;
        List<V> incomingEdges = this.edgeListReversed.get(target);
        if (incomingEdges != null) {
            containedEdge = incomingEdges.remove(source);
        }
        if ((outgoingEdges = this.edgeList.get(source)) != null) {
            outgoingEdges.remove(target);
        }
        if (containedEdge) {
            for (IGraphObserver<V> go : this.observers) {
                go.edgeDeleted(source, target);
            }
        }
    }

    public void insertNode(V node) {
        if (!this.edgeList.containsKey(node)) {
            this.edgeList.put(node, null);
        }
        if (!this.edgeListReversed.containsKey(node)) {
            this.edgeListReversed.put(node, null);
        }
        for (IGraphObserver<V> go : this.observers) {
            go.nodeInserted(node);
        }
    }

    public void deleteNode(V node) {
        ArrayList<V> tmp;
        boolean containedNode = this.edgeList.containsKey(node);
        List<V> incomingEdges = this.edgeListReversed.get(node);
        List<V> outgoingEdges = this.edgeList.get(node);
        if (incomingEdges != null) {
            tmp = new ArrayList<V>(incomingEdges);
            for (Object s : tmp) {
                this.deleteEdge(s, node);
            }
        }
        if (outgoingEdges != null) {
            tmp = new ArrayList<V>(outgoingEdges);
            for (Object t : tmp) {
                this.deleteEdge(node, t);
            }
        }
        if (containedNode) {
            for (IGraphObserver<V> go : this.observers) {
                go.nodeDeleted(node);
            }
        }
    }

    @Override
    public void attachObserver(IGraphObserver<V> go) {
        this.observers.add(go);
    }

    @Override
    public void detachObserver(IGraphObserver<V> go) {
        this.observers.remove(go);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.edgeList.keySet();
    }

    @Override
    public List<V> getTargetNodes(V source) {
        return this.edgeList.get(source);
    }

    @Override
    public List<V> getSourceNodes(V target) {
        return this.edgeListReversed.get(target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes = ");
        for (V n : this.edgeList.keySet()) {
            sb.append(String.valueOf(n.toString()) + " ");
        }
        sb.append(" edges = ");
        for (V source : this.edgeList.keySet()) {
            if (this.edgeList.get(source) == null) continue;
            for (V target : this.edgeList.get(source)) {
                sb.append("(" + source + "," + target + ") ");
            }
        }
        return sb.toString();
    }

    public Integer[] deleteRandomEdge() {
        return null;
    }

    public Integer[] insertRandomEdge() {
        return null;
    }
}

