/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.api;

import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IndexingService;

public enum IndexingLevel {
    NONE,
    STATISTICS,
    NOTIFICATIONS,
    BOTH,
    FULL;

    private static final IndexingLevel[][] mergeTable;

    static {
        mergeTable = new IndexingLevel[][]{{NONE, STATISTICS, NOTIFICATIONS, BOTH, FULL}, {STATISTICS, STATISTICS, BOTH, BOTH, FULL}, {NOTIFICATIONS, BOTH, NOTIFICATIONS, BOTH, FULL}, {BOTH, BOTH, BOTH, BOTH, FULL}, {FULL, FULL, FULL, FULL, FULL}};
    }

    public static IndexingLevel toLevel(IndexingService service) {
        switch (service) {
            case INSTANCES: {
                return FULL;
            }
            case NOTIFICATIONS: {
                return NOTIFICATIONS;
            }
            case STATISTICS: {
                return STATISTICS;
            }
        }
        return NONE;
    }

    public static IndexingLevel toLevel(Set<IndexingService> services) {
        IndexingLevel result = NONE;
        for (IndexingService service : services) {
            result = result.merge(IndexingLevel.toLevel(service));
        }
        return result;
    }

    public IndexingLevel merge(IndexingLevel other) {
        if (other == null) {
            return this;
        }
        return mergeTable[this.ordinal()][other.ordinal()];
    }

    public boolean hasStatistics() {
        return this == BOTH || this == STATISTICS || this == FULL;
    }

    public boolean hasInstances() {
        return this == FULL;
    }
}

