/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public interface IVariableRenamer {
    public String createVariableName(PVariable var1, PQuery var2);

    public static class HierarchicalName
    implements IVariableRenamer {
        private int callCount;

        public void setCallCount(int callCount) {
            this.callCount = callCount;
        }

        @Override
        public String createVariableName(PVariable pVariable, PQuery query) {
            String newVarName = String.valueOf(this.getShortName(query)) + "<" + this.callCount + ">" + "_" + pVariable.getName();
            return pVariable.getName().startsWith("_") ? "_" + newVarName : newVarName;
        }

        private String getShortName(PQuery query) {
            String fullyQualifiedName = query.getFullyQualifiedName();
            int beginIndex = fullyQualifiedName.lastIndexOf(".") + 1;
            return fullyQualifiedName.substring(beginIndex);
        }
    }

    public static class SameName
    implements IVariableRenamer {
        @Override
        public String createVariableName(PVariable pVariable, PQuery query) {
            return pVariable.getName();
        }
    }
}

