/**
 */
package org.eclipse.viatra.query.runtime.rete.recipes.impl;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;

import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesPackage;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SingleColumnAggregatorRecipe;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Single Column Aggregator Recipe</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.runtime.rete.recipes.impl.SingleColumnAggregatorRecipeImpl#getGroupByMask <em>Group By Mask</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.runtime.rete.recipes.impl.SingleColumnAggregatorRecipeImpl#getAggregableIndex <em>Aggregable Index</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.runtime.rete.recipes.impl.SingleColumnAggregatorRecipeImpl#getMultisetAggregationOperator <em>Multiset Aggregation Operator</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SingleColumnAggregatorRecipeImpl extends AlphaRecipeImpl implements SingleColumnAggregatorRecipe {
	/**
	 * The cached value of the '{@link #getGroupByMask() <em>Group By Mask</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroupByMask()
	 * @generated
	 * @ordered
	 */
	protected Mask groupByMask;

	/**
	 * The default value of the '{@link #getAggregableIndex() <em>Aggregable Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregableIndex()
	 * @generated
	 * @ordered
	 */
	protected static final Integer AGGREGABLE_INDEX_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAggregableIndex() <em>Aggregable Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregableIndex()
	 * @generated
	 * @ordered
	 */
	protected Integer aggregableIndex = AGGREGABLE_INDEX_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMultisetAggregationOperator() <em>Multiset Aggregation Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMultisetAggregationOperator()
	 * @generated
	 * @ordered
	 */
	protected IMultisetAggregationOperator<?, ?, ?> multisetAggregationOperator;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleColumnAggregatorRecipeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RecipesPackage.Literals.SINGLE_COLUMN_AGGREGATOR_RECIPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Mask getGroupByMask() {
		return groupByMask;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGroupByMask(Mask newGroupByMask, NotificationChain msgs) {
		Mask oldGroupByMask = groupByMask;
		groupByMask = newGroupByMask;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK, oldGroupByMask, newGroupByMask);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGroupByMask(Mask newGroupByMask) {
		if (newGroupByMask != groupByMask) {
			NotificationChain msgs = null;
			if (groupByMask != null)
				msgs = ((InternalEObject)groupByMask).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK, null, msgs);
			if (newGroupByMask != null)
				msgs = ((InternalEObject)newGroupByMask).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK, null, msgs);
			msgs = basicSetGroupByMask(newGroupByMask, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK, newGroupByMask, newGroupByMask));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Integer getAggregableIndex() {
		return aggregableIndex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAggregableIndex(Integer newAggregableIndex) {
		Integer oldAggregableIndex = aggregableIndex;
		aggregableIndex = newAggregableIndex;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__AGGREGABLE_INDEX, oldAggregableIndex, aggregableIndex));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMultisetAggregationOperator<?, ?, ?> getMultisetAggregationOperator() {
		return multisetAggregationOperator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMultisetAggregationOperator(IMultisetAggregationOperator<?, ?, ?> newMultisetAggregationOperator) {
		IMultisetAggregationOperator<?, ?, ?> oldMultisetAggregationOperator = multisetAggregationOperator;
		multisetAggregationOperator = newMultisetAggregationOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__MULTISET_AGGREGATION_OPERATOR, oldMultisetAggregationOperator, multisetAggregationOperator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getArity() {
		Mask _mask = this.getGroupByMask();
		EList<Integer> _sourceIndices = _mask.getSourceIndices();
		return 1 +  _sourceIndices.size();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK:
				return basicSetGroupByMask(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK:
				return getGroupByMask();
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__AGGREGABLE_INDEX:
				return getAggregableIndex();
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__MULTISET_AGGREGATION_OPERATOR:
				return getMultisetAggregationOperator();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK:
				setGroupByMask((Mask)newValue);
				return;
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__AGGREGABLE_INDEX:
				setAggregableIndex((Integer)newValue);
				return;
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__MULTISET_AGGREGATION_OPERATOR:
				setMultisetAggregationOperator((IMultisetAggregationOperator<?, ?, ?>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK:
				setGroupByMask((Mask)null);
				return;
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__AGGREGABLE_INDEX:
				setAggregableIndex(AGGREGABLE_INDEX_EDEFAULT);
				return;
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__MULTISET_AGGREGATION_OPERATOR:
				setMultisetAggregationOperator((IMultisetAggregationOperator<?, ?, ?>)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__GROUP_BY_MASK:
				return groupByMask != null;
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__AGGREGABLE_INDEX:
				return AGGREGABLE_INDEX_EDEFAULT == null ? aggregableIndex != null : !AGGREGABLE_INDEX_EDEFAULT.equals(aggregableIndex);
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE__MULTISET_AGGREGATION_OPERATOR:
				return multisetAggregationOperator != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
		if (baseClass == ReteNodeRecipe.class) {
			switch (baseOperationID) {
				case RecipesPackage.RETE_NODE_RECIPE___GET_ARITY: return RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE___GET_ARITY;
				default: return super.eDerivedOperationID(baseOperationID, baseClass);
			}
		}
		return super.eDerivedOperationID(baseOperationID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case RecipesPackage.SINGLE_COLUMN_AGGREGATOR_RECIPE___GET_ARITY:
				return getArity();
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (aggregableIndex: ");
		result.append(aggregableIndex);
		result.append(", multisetAggregationOperator: ");
		result.append(multisetAggregationOperator);
		result.append(')');
		return result.toString();
	}

} //SingleColumnAggregatorRecipeImpl
