/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.LeftInheritanceTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.aggregation.IAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;
import org.eclipse.viatra.query.runtime.rete.tuple.Clearable;

public class ColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends SingleInputNode
implements Clearable,
IAggregatorNode {
    private IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator;
    private TupleMask groupByMask;
    private int aggregableColumnIndex;
    private int sourceWidth;
    private IQueryRuntimeContext runtimeContext;
    Map<Tuple, Accumulator> accumulatorsByGroup = CollectionsFactory.getMap();
    AggregatorOuterIndexer aggregatorOuterIndexer = null;
    AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexers = null;

    public ColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupByMask, int aggregableColumnIndex) {
        super(reteContainer);
        this.operator = operator;
        this.groupByMask = groupByMask;
        this.aggregableColumnIndex = aggregableColumnIndex;
        this.sourceWidth = groupByMask.indices.length;
        this.runtimeContext = reteContainer.getNetwork().getEngine().getRuntimeContext();
        reteContainer.registerClearable(this);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendChild(Receiver receiver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Indexer getAggregatorOuterIndexer() {
        if (this.aggregatorOuterIndexer == null) {
            this.aggregatorOuterIndexer = new AggregatorOuterIndexer();
        }
        return this.aggregatorOuterIndexer;
    }

    @Override
    public Indexer getAggregatorOuterIdentityIndexer(int resultPositionInSignature) {
        if (this.aggregatorOuterIdentityIndexers == null) {
            this.aggregatorOuterIdentityIndexers = new AggregatorOuterIdentityIndexer[this.sourceWidth + 1];
        }
        if (this.aggregatorOuterIdentityIndexers[resultPositionInSignature] == null) {
            this.aggregatorOuterIdentityIndexers[resultPositionInSignature] = new AggregatorOuterIdentityIndexer(resultPositionInSignature);
        }
        return this.aggregatorOuterIdentityIndexers[resultPositionInSignature];
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        boolean isInsertion;
        Tuple updateGroup = this.groupByMask.transform(updateElement);
        Accumulator oldAccumulator = this.getCurrentAccumulator(updateGroup);
        Object oldAggregateResult = this.operator.getAggregate(oldAccumulator);
        Object aggregableValue = this.runtimeContext.unwrapElement(updateElement.get(this.aggregableColumnIndex));
        Object newAccumulator = this.operator.update(oldAccumulator, aggregableValue, isInsertion = direction == Direction.INSERT);
        if (this.operator.isNeutral(newAccumulator)) {
            this.accumulatorsByGroup.remove(updateGroup);
        } else {
            this.accumulatorsByGroup.put(updateGroup, newAccumulator);
        }
        Object newAggregateResult = this.operator.getAggregate(newAccumulator);
        if (Objects.equals(oldAggregateResult, newAggregateResult)) {
            return;
        }
        Tuple oldResultTuple = this.tupleFromAggregateResult(updateGroup, oldAggregateResult);
        Tuple newResultTuple = this.tupleFromAggregateResult(updateGroup, newAggregateResult);
        if (this.aggregatorOuterIndexer != null) {
            this.aggregatorOuterIndexer.propagate(updateGroup, oldResultTuple, newResultTuple);
        }
        if (this.aggregatorOuterIdentityIndexers != null) {
            AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexerArray = this.aggregatorOuterIdentityIndexers;
            int n = this.aggregatorOuterIdentityIndexers.length;
            int n2 = 0;
            while (n2 < n) {
                AggregatorOuterIdentityIndexer aggregatorOuterIdentityIndexer = aggregatorOuterIdentityIndexerArray[n2];
                if (aggregatorOuterIdentityIndexer != null) {
                    aggregatorOuterIdentityIndexer.propagate(updateGroup, oldResultTuple, newResultTuple);
                }
                ++n2;
            }
        }
    }

    @Override
    public void clear() {
        this.accumulatorsByGroup.clear();
    }

    public Tuple getAggregateTuple(Tuple groupTuple) {
        Accumulator accumulator = this.getCurrentAccumulator(groupTuple);
        Object aggregateResult = this.operator.getAggregate(accumulator);
        return this.tupleFromAggregateResult(groupTuple, aggregateResult);
    }

    public AggregateResult getAggregateResult(Tuple groupTuple) {
        Accumulator accumulator = this.getCurrentAccumulator(groupTuple);
        return (AggregateResult)this.operator.getAggregate(accumulator);
    }

    private Accumulator getCurrentAccumulator(Tuple groupTuple) {
        Object accumulator = this.accumulatorsByGroup.get(groupTuple);
        if (accumulator == null) {
            accumulator = this.operator.createNeutral();
        }
        return accumulator;
    }

    protected Tuple tupleFromAggregateResult(Tuple groupTuple, AggregateResult aggregateResult) {
        if (aggregateResult == null) {
            return null;
        }
        Object[] resultArray = new Object[]{this.runtimeContext.wrapElement(aggregateResult)};
        return new LeftInheritanceTuple(groupTuple, resultArray);
    }

    class AggregatorOuterIdentityIndexer
    extends StandardIndexer {
        int resultPositionInSignature;
        TupleMask pruneResult;
        TupleMask reorderMask;

        public AggregatorOuterIdentityIndexer(int resultPositionInSignature) {
            super(ColumnAggregatorNode.this.reteContainer, TupleMask.displace((int)ColumnAggregatorNode.this.sourceWidth, (int)resultPositionInSignature, (int)(ColumnAggregatorNode.this.sourceWidth + 1)));
            this.parent = ColumnAggregatorNode.this;
            this.resultPositionInSignature = resultPositionInSignature;
            this.pruneResult = TupleMask.omit((int)resultPositionInSignature, (int)(ColumnAggregatorNode.this.sourceWidth + 1));
            this.reorderMask = resultPositionInSignature == ColumnAggregatorNode.this.sourceWidth ? null : this.mask;
        }

        @Override
        public Collection<Tuple> get(Tuple signatureWithResult) {
            Tuple prunedSignature = this.pruneResult.transform(signatureWithResult);
            Object result = ColumnAggregatorNode.this.getAggregateResult(prunedSignature);
            if (result != null && Objects.equals(signatureWithResult.get(this.resultPositionInSignature), result)) {
                return Collections.singleton(signatureWithResult);
            }
            return null;
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple) {
            if (oldTuple != null) {
                this.propagate(Direction.REVOKE, this.reorder(oldTuple), signature, true);
            }
            if (newTuple != null) {
                this.propagate(Direction.INSERT, this.reorder(newTuple), signature, true);
            }
        }

        private Tuple reorder(Tuple signatureWithResult) {
            Tuple transformed = this.reorderMask == null ? signatureWithResult : this.reorderMask.transform(signatureWithResult);
            return transformed;
        }

        @Override
        public Node getActiveNode() {
            return ColumnAggregatorNode.this;
        }
    }

    class AggregatorOuterIndexer
    extends StandardIndexer {
        public AggregatorOuterIndexer() {
            super(ColumnAggregatorNode.this.reteContainer, TupleMask.omit((int)ColumnAggregatorNode.this.sourceWidth, (int)(ColumnAggregatorNode.this.sourceWidth + 1)));
            this.parent = ColumnAggregatorNode.this;
        }

        @Override
        public Collection<Tuple> get(Tuple signature) {
            Tuple aggregateTuple = ColumnAggregatorNode.this.getAggregateTuple(signature);
            return aggregateTuple == null ? null : Collections.singleton(aggregateTuple);
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple) {
            if (oldTuple != null) {
                this.propagate(Direction.REVOKE, oldTuple, signature, true);
            }
            if (newTuple != null) {
                this.propagate(Direction.INSERT, newTuple, signature, true);
            }
        }

        @Override
        public Node getActiveNode() {
            return ColumnAggregatorNode.this;
        }
    }
}

