/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api.impl;

import java.util.List;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;

public abstract class BaseQuerySpecification<Matcher extends ViatraQueryMatcher<? extends IPatternMatch>>
implements IQuerySpecification<Matcher> {
    protected final PQuery wrappedPQuery;

    protected abstract Matcher instantiate(ViatraQueryEngine var1) throws ViatraQueryException;

    @Override
    public Matcher instantiate() throws ViatraQueryException {
        return null;
    }

    public BaseQuerySpecification(PQuery wrappedPQuery) {
        this.wrappedPQuery = wrappedPQuery;
        wrappedPQuery.publishedAs().add(this);
    }

    @Override
    public PQuery getInternalQueryRepresentation() {
        return this.wrappedPQuery;
    }

    @Override
    public Matcher getMatcher(ViatraQueryEngine engine) throws ViatraQueryException {
        this.ensureInitializedInternal();
        if (engine.getScope().isCompatibleWithQueryScope(this.getPreferredScopeClass())) {
            return this.instantiate(engine);
        }
        throw new ViatraQueryException(String.format("Scope class incompatibility: the query %s is formulated over query scopes of class %s,  thus the query engine formulated over scope %s of class %s cannot evaluate it.", this.getFullyQualifiedName(), this.getPreferredScopeClass().getCanonicalName(), engine.getScope(), engine.getScope().getClass().getCanonicalName()), "Incompatible scope classes of engine and query.");
    }

    protected void ensureInitializedInternal() throws ViatraQueryException {
        try {
            this.wrappedPQuery.ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new ViatraQueryException(e);
        }
    }

    protected void ensureInitializedInternalSneaky() {
        try {
            this.wrappedPQuery.ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PAnnotation> getAllAnnotations() {
        return this.wrappedPQuery.getAllAnnotations();
    }

    public List<PAnnotation> getAnnotationsByName(String annotationName) {
        return this.wrappedPQuery.getAnnotationsByName(annotationName);
    }

    public PAnnotation getFirstAnnotationByName(String annotationName) {
        return this.wrappedPQuery.getFirstAnnotationByName(annotationName);
    }

    public String getFullyQualifiedName() {
        return this.wrappedPQuery.getFullyQualifiedName();
    }

    public List<String> getParameterNames() {
        return this.wrappedPQuery.getParameterNames();
    }

    public List<PParameter> getParameters() {
        return this.wrappedPQuery.getParameters();
    }

    public Integer getPositionOfParameter(String parameterName) {
        return this.wrappedPQuery.getPositionOfParameter(parameterName);
    }
}

