/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.emf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.BaseEMFTypeKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.AbstractQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.InputKeyImplication;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;

public final class EMFQueryMetaContext
extends AbstractQueryMetaContext {
    public static final EMFQueryMetaContext INSTANCE = new EMFQueryMetaContext();

    private EMFQueryMetaContext() {
    }

    public boolean isEnumerable(IInputKey key) {
        this.ensureValidKey(key);
        return key.isEnumerable();
    }

    public boolean isStateless(IInputKey key) {
        this.ensureValidKey(key);
        return key instanceof JavaTransitiveInstancesKey;
    }

    public Map<Set<Integer>, Set<Integer>> getFunctionalDependencies(IInputKey key) {
        this.ensureValidKey(key);
        if (key instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)key).getEmfKey();
            HashMap<Set<Integer>, Set<Integer>> result = new HashMap<Set<Integer>, Set<Integer>>();
            if (this.isFeatureMultiplicityToOne(feature)) {
                result.put(Collections.singleton(0), Collections.singleton(1));
            }
            if (this.isFeatureMultiplicityOneTo(feature)) {
                result.put(Collections.singleton(1), Collections.singleton(0));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public Collection<InputKeyImplication> getImplications(IInputKey implyingKey) {
        this.ensureValidKey(implyingKey);
        HashSet<InputKeyImplication> result = new HashSet<InputKeyImplication>();
        if (implyingKey instanceof EClassTransitiveInstancesKey) {
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)implyingKey).getEmfKey();
            EList directSuperTypes = eClass.getESuperTypes();
            for (EClass superType : directSuperTypes) {
                EClassTransitiveInstancesKey implied = new EClassTransitiveInstancesKey(superType);
                result.add(new InputKeyImplication(implyingKey, (IInputKey)implied, Arrays.asList(0)));
            }
        } else if (implyingKey instanceof JavaTransitiveInstancesKey) {
            Class instanceClass = ((JavaTransitiveInstancesKey)implyingKey).getInstanceClass();
            if (instanceClass != null) {
                Class superclass = instanceClass.getSuperclass();
                if (superclass != null) {
                    JavaTransitiveInstancesKey impliedSuper = new JavaTransitiveInstancesKey(superclass);
                    result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedSuper, Arrays.asList(0)));
                }
                Class<?>[] classArray = instanceClass.getInterfaces();
                int implied = classArray.length;
                int n = 0;
                while (n < implied) {
                    Class<?> superInterface = classArray[n];
                    if (superInterface != null) {
                        JavaTransitiveInstancesKey impliedInterface = new JavaTransitiveInstancesKey(superInterface);
                        result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedInterface, Arrays.asList(0)));
                    }
                    ++n;
                }
            }
        } else if (implyingKey instanceof EStructuralFeatureInstancesKey) {
            EStructuralFeature feature = (EStructuralFeature)((EStructuralFeatureInstancesKey)implyingKey).getEmfKey();
            EClass sourceType = this.featureSourceType(feature);
            EClassTransitiveInstancesKey impliedSource = new EClassTransitiveInstancesKey(sourceType);
            EClassifier targetType = this.featureTargetType(feature);
            BaseEMFTypeKey impliedTarget = targetType instanceof EClass ? new EClassTransitiveInstancesKey((EClass)targetType) : new EDataTypeInSlotsKey((EDataType)targetType);
            result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedSource, Arrays.asList(0)));
            result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedTarget, Arrays.asList(1)));
            EReference opposite = this.featureOpposite(feature);
            if (opposite != null) {
                EStructuralFeatureInstancesKey impliedOpposite = new EStructuralFeatureInstancesKey((EStructuralFeature)opposite);
                result.add(new InputKeyImplication(implyingKey, (IInputKey)impliedOpposite, Arrays.asList(1, 0)));
            }
        } else if (implyingKey instanceof EDataTypeInSlotsKey) {
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)implyingKey).getEmfKey();
            Class instanceClass = dataType.getInstanceClass();
            if (instanceClass != null) {
                JavaTransitiveInstancesKey implied = new JavaTransitiveInstancesKey(instanceClass);
                result.add(new InputKeyImplication(implyingKey, (IInputKey)implied, Arrays.asList(0)));
            }
        } else {
            this.illegalInputKey(implyingKey);
        }
        return result;
    }

    public void ensureValidKey(IInputKey key) {
        if (!(key instanceof BaseEMFTypeKey) && !(key instanceof JavaTransitiveInstancesKey)) {
            this.illegalInputKey(key);
        }
    }

    public void illegalInputKey(IInputKey key) {
        throw new IllegalArgumentException("The input key " + key + " is not a valid EMF input key.");
    }

    public boolean isFeatureMultiplicityToOne(EStructuralFeature feature) {
        return !feature.isMany();
    }

    public boolean isFeatureMultiplicityOneTo(EStructuralFeature typeObject) {
        if (typeObject instanceof EReference) {
            EReference feature = (EReference)typeObject;
            EReference eOpposite = feature.getEOpposite();
            return feature.isContainment() || eOpposite != null && !eOpposite.isMany();
        }
        return false;
    }

    public EClass featureSourceType(EStructuralFeature feature) {
        return feature.getEContainingClass();
    }

    public EClassifier featureTargetType(EStructuralFeature typeObject) {
        if (typeObject instanceof EAttribute) {
            EAttribute attribute = (EAttribute)typeObject;
            return attribute.getEAttributeType();
        }
        if (typeObject instanceof EReference) {
            EReference reference = (EReference)typeObject;
            return reference.getEReferenceType();
        }
        throw new IllegalArgumentException("typeObject has invalid type " + typeObject.getClass().getName());
    }

    public EReference featureOpposite(EStructuralFeature typeObject) {
        if (typeObject instanceof EReference) {
            EReference reference = (EReference)typeObject;
            return reference.getEOpposite();
        }
        return null;
    }
}

