/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.internal.boundary.unused;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.boundary.Disconnectable;
import org.eclipse.viatra.query.runtime.rete.index.IdentityIndexer;
import org.eclipse.viatra.query.runtime.rete.index.NullIndexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public class EClassUnaryInputNode
extends StandardNode
implements Disconnectable {
    private EClass clazz;
    private NavigationHelper baseIndex;
    private ReteEngine reteEngine;
    static final TupleMask nullMask = TupleMask.linear((int)0, (int)1);
    static final TupleMask identityMask = TupleMask.identity((int)1);
    private NullIndexer nullIndexer;
    private IdentityIndexer identityIndexer;
    private InstanceListener listener = new InstanceListener(){

        public void instanceInserted(EClass clazz, EObject instance) {
            Tuple tuple = EClassUnaryInputNode.this.makeTuple(instance);
            EClassUnaryInputNode.this.propagate(Direction.INSERT, tuple);
        }

        public void instanceDeleted(EClass clazz, EObject instance) {
            Tuple tuple = EClassUnaryInputNode.this.makeTuple(instance);
            EClassUnaryInputNode.this.propagate(Direction.REVOKE, tuple);
        }
    };

    public EClassUnaryInputNode(ReteEngine engine, ReteContainer reteContainer, EClass clazz) {
        super(reteContainer);
        this.reteEngine = engine;
        this.clazz = clazz;
        this.setTag(clazz.getName());
        this.baseIndex.addInstanceListener(Collections.singleton(clazz), this.listener);
        this.reteEngine.addDisconnectable((Disconnectable)this);
    }

    public void pullInto(Collection<Tuple> collector) {
        collector.addAll(this.tuples());
    }

    public void disconnect() {
    }

    protected Tuple makeTuple(EObject instance) {
        return new FlatTuple(new Object[]{instance});
    }

    protected void propagate(Direction direction, Tuple tuple) {
        this.propagateUpdate(direction, tuple);
        if (this.identityIndexer != null) {
            this.identityIndexer.propagate(direction, tuple);
        }
        if (this.nullIndexer != null) {
            this.nullIndexer.propagate(direction, tuple);
        }
    }

    protected Collection<Tuple> tuples() {
        HashSet<Tuple> result = new HashSet<Tuple>();
        return result;
    }

    public ProjectionIndexer constructIndex(TupleMask mask, TraceInfo ... traces) {
        if (nullMask.equals((Object)mask)) {
            NullIndexer indexer = this.getNullIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                TraceInfo traceInfo = traceInfoArray[n2];
                indexer.assignTraceInfo(traceInfo);
                ++n2;
            }
            return indexer;
        }
        if (identityMask.equals((Object)mask)) {
            IdentityIndexer indexer = this.getIdentityIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n3 = 0;
            while (n3 < n) {
                TraceInfo traceInfo = traceInfoArray[n3];
                indexer.assignTraceInfo(traceInfo);
                ++n3;
            }
            return indexer;
        }
        return super.constructIndex(mask, traces);
    }

    public NullIndexer getNullIndexer() {
        if (this.nullIndexer == null) {
            this.nullIndexer = new NullIndexer(this.reteContainer, 1, (Supplier)this, (Node)this){

                protected Collection<Tuple> getTuples() {
                    return EClassUnaryInputNode.this.tuples();
                }

                protected boolean isEmpty() {
                    return false;
                }

                protected boolean isSingleElement() {
                    return false;
                }
            };
        }
        return this.nullIndexer;
    }

    public IdentityIndexer getIdentityIndexer() {
        if (this.identityIndexer == null) {
            this.identityIndexer = new IdentityIndexer(this.reteContainer, 1, (Supplier)this, (Node)this){

                protected Collection<Tuple> getTuples() {
                    return EClassUnaryInputNode.this.tuples();
                }

                protected boolean contains(Tuple signature) {
                    try {
                        return signature.getSize() == 1 && EClassUnaryInputNode.this.clazz.isInstance(signature.get(0));
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
        }
        return this.identityIndexer;
    }
}

