/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.tooling.localsearch.ui.LocalSearchToolingActivator;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.SearchOperationViewerNode;

public class OperationListLabelProvider
extends StyledCellLabelProvider {
    private List<SearchPlanExecutor> planExecutors = Lists.newArrayList();
    private LocalResourceManager localResourceManager;
    private ImageRegistry imageRegistry = LocalSearchToolingActivator.getDefault().getImageRegistry();
    private Map<Object, SearchPlanExecutor> dummyMatchOperationMappings = Maps.newHashMap();

    public void update(ViewerCell cell) {
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources((Display)Display.getCurrent()));
        final SearchOperationViewerNode node = (SearchOperationViewerNode)cell.getElement();
        StyledString text = new StyledString();
        text.append(node.getLabelText());
        switch (node.getOperationStatus()) {
            case EXECUTED: {
                cell.setImage(this.imageRegistry.get("applied_operation"));
                text.setStyle(0, text.length(), new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = OperationListLabelProvider.this.localResourceManager.createFont(FontDescriptor.createFrom((String)"Arial", (int)10, (int)1));
                        OperationListLabelProvider.this.doColoring(node, textStyle);
                    }
                });
                break;
            }
            case CURRENT: {
                cell.setImage(this.imageRegistry.get("current_operation"));
                text.setStyle(0, text.length(), new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        LocalResourceManager localResMan = new LocalResourceManager(JFaceResources.getResources((Display)Display.getCurrent()));
                        textStyle.font = localResMan.createFont(FontDescriptor.createFrom((String)"Arial", (int)10, (int)3));
                        OperationListLabelProvider.this.doColoring(node, textStyle);
                        textStyle.background = OperationListLabelProvider.this.localResourceManager.createColor(new RGB(200, 235, 255));
                    }
                });
                break;
            }
            case QUEUED: {
                cell.setImage(this.imageRegistry.get("not_applied_operation"));
                text.setStyle(0, text.length(), new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        LocalResourceManager localResMan = new LocalResourceManager(JFaceResources.getResources((Display)Display.getCurrent()));
                        textStyle.font = localResMan.createFont(FontDescriptor.createFrom((String)"Arial", (int)10, (int)0));
                        OperationListLabelProvider.this.doColoring(node, textStyle);
                    }
                });
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation status: " + (Object)((Object)node.getOperationStatus()));
            }
        }
        cell.setText(text.toString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }

    private void doColoring(SearchOperationViewerNode node, TextStyle textStyle) {
        switch (node.getOperationKind()) {
            case EXTEND: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(0, 200, 0));
                break;
            }
            case COUNT: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(200, 200, 200));
                break;
            }
            case NAC: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(230, 0, 0));
                break;
            }
            case CHECK: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(100, 100, 100));
                break;
            }
            case MATCH: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(0, 0, 255));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation kind: " + (Object)((Object)node.getOperationKind()));
            }
        }
        if (node.isBreakpoint()) {
            textStyle.borderStyle = 1;
            textStyle.borderColor = this.localResourceManager.createColor(new RGB(200, 0, 0));
        }
    }

    public List<SearchPlanExecutor> getPlanExecutorList() {
        return this.planExecutors;
    }

    public void dispose() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
        }
        super.dispose();
    }

    public void createDummyMatchOperationMapping(Object dummyOperation, SearchPlanExecutor inputElement) {
        this.dummyMatchOperationMappings.put(dummyOperation, inputElement);
    }

    public Object getDummyMatchOperation(SearchPlanExecutor planExecutor) {
        for (Object key : this.dummyMatchOperationMappings.keySet()) {
            if (!this.dummyMatchOperationMappings.get(key).equals(planExecutor)) continue;
            return key;
        }
        return null;
    }
}

