/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Objects;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInputChange;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;

@SuppressWarnings("all")
public class QueryRegistryTreeViewListener implements IQuerySpecificationRegistryChangeListener {
  public QueryRegistryTreeInput input;
  
  public QueryRegistryTreeContentProvider provider;
  
  @Override
  public void entryAdded(final IQuerySpecificationRegistryEntry entry) {
    final QueryRegistryTreeInputChange newEntry = this.input.addEntryToInput(entry);
    boolean _notEquals = (!Objects.equal(this.provider, null));
    if (_notEquals) {
      Tree _tree = this.provider.viewer.getTree();
      Display _display = _tree.getDisplay();
      final Runnable _function = new Runnable() {
        @Override
        public void run() {
          boolean _isSourceAffected = newEntry.isSourceAffected();
          if (_isSourceAffected) {
            QueryRegistryTreeSource _source = newEntry.getSource();
            QueryRegistryTreeViewListener.this.provider.viewer.add(QueryRegistryTreeViewListener.this.input, _source);
          }
          boolean _isPckgAffected = newEntry.isPckgAffected();
          if (_isPckgAffected) {
            QueryRegistryTreeSource _source_1 = newEntry.getSource();
            QueryRegistryTreePackage _pckg = newEntry.getPckg();
            QueryRegistryTreeViewListener.this.provider.viewer.add(_source_1, _pckg);
          }
          QueryRegistryTreePackage _pckg_1 = newEntry.getPckg();
          QueryRegistryTreeEntry _entry = newEntry.getEntry();
          QueryRegistryTreeViewListener.this.provider.viewer.add(_pckg_1, _entry);
        }
      };
      _display.asyncExec(_function);
    }
  }
  
  @Override
  public void entryRemoved(final IQuerySpecificationRegistryEntry entry) {
    final QueryRegistryTreeInputChange oldEntry = this.input.removeEntry(entry);
    if (((!Objects.equal(oldEntry, null)) && (!Objects.equal(this.provider, null)))) {
      Tree _tree = this.provider.viewer.getTree();
      Display _display = _tree.getDisplay();
      final Runnable _function = new Runnable() {
        @Override
        public void run() {
          QueryRegistryTreeEntry _entry = oldEntry.getEntry();
          QueryRegistryTreeViewListener.this.provider.viewer.remove(_entry);
          boolean _isPckgAffected = oldEntry.isPckgAffected();
          if (_isPckgAffected) {
            QueryRegistryTreePackage _pckg = oldEntry.getPckg();
            QueryRegistryTreeViewListener.this.provider.viewer.remove(_pckg);
          }
          boolean _isSourceAffected = oldEntry.isSourceAffected();
          if (_isSourceAffected) {
            QueryRegistryTreeSource _source = oldEntry.getSource();
            QueryRegistryTreeViewListener.this.provider.viewer.remove(_source);
          }
        }
      };
      _display.asyncExec(_function);
    }
  }
}
