/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.XtextIndexBasedRegistryUpdater;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.XtextIndexBasedRegistryUpdaterFactory;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class LoadVqlPatternHandler extends AbstractHandler {
  @Inject
  Injector injector;
  
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    final IEditorPart editorPart = HandlerUtil.getActiveEditorChecked(event);
    IWorkbenchSite _activeSite = HandlerUtil.getActiveSite(event);
    IWorkbenchPage _page = _activeSite.getPage();
    final IViewPart resultView = _page.findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      QueryResultView queryResultView = ((QueryResultView) resultView);
      final boolean active = queryResultView.hasActiveEngine();
      if ((active && (editorPart instanceof XtextEditor))) {
        final XtextEditor xtextEditor = ((XtextEditor) editorPart);
        final IResource resource = xtextEditor.getResource();
        IProject _project = resource.getProject();
        String _name = _project.getName();
        final String sourceId = (XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX + _name);
        IXtextDocument _document = xtextEditor.getDocument();
        final IUnitOfWork<Iterable<String>, XtextResource> _function = new IUnitOfWork<Iterable<String>, XtextResource>() {
          @Override
          public Iterable<String> exec(final XtextResource state) throws Exception {
            EList<EObject> _contents = state.getContents();
            Iterable<PatternModel> _filter = Iterables.<PatternModel>filter(_contents, PatternModel.class);
            final Function1<PatternModel, EList<Pattern>> _function = new Function1<PatternModel, EList<Pattern>>() {
              @Override
              public EList<Pattern> apply(final PatternModel it) {
                return it.getPatterns();
              }
            };
            Iterable<EList<Pattern>> _map = IterableExtensions.<PatternModel, EList<Pattern>>map(_filter, _function);
            Iterable<Pattern> _flatten = Iterables.<Pattern>concat(_map);
            final Function1<Pattern, String> _function_1 = new Function1<Pattern, String>() {
              @Override
              public String apply(final Pattern it) {
                return CorePatternLanguageHelper.getFullyQualifiedName(it);
              }
            };
            final Iterable<String> fqns = IterableExtensions.<Pattern, String>map(_flatten, _function_1);
            return fqns;
          }
        };
        final Iterable<String> patternFQNs = _document.<Iterable<String>>readOnly(_function);
        IQuerySpecificationRegistry _instance = QuerySpecificationRegistry.getInstance();
        XtextIndexBasedRegistryUpdaterFactory.INSTANCE.getUpdater(_instance);
        IQuerySpecificationRegistry _instance_1 = QuerySpecificationRegistry.getInstance();
        final IRegistryViewFilter _function_1 = new IRegistryViewFilter() {
          @Override
          public boolean isEntryRelevant(final IQuerySpecificationRegistryEntry entry) {
            String _sourceIdentifier = entry.getSourceIdentifier();
            final boolean sourceSame = Objects.equal(_sourceIdentifier, sourceId);
            final Function1<String, Boolean> _function = new Function1<String, Boolean>() {
              @Override
              public Boolean apply(final String it) {
                String _fullyQualifiedName = entry.getFullyQualifiedName();
                return Boolean.valueOf(Objects.equal(it, _fullyQualifiedName));
              }
            };
            final boolean fqnRelevant = IterableExtensions.<String>exists(patternFQNs, _function);
            return (sourceSame && fqnRelevant);
          }
        };
        final IRegistryView view = _instance_1.createView(_function_1);
        Iterable<IQuerySpecificationRegistryEntry> _entries = view.getEntries();
        queryResultView.loadQueriesIntoActiveEngine(_entries);
      } else {
        IWorkbenchPartSite _site = queryResultView.getSite();
        Shell _shell = _site.getShell();
        MessageDialog.openError(_shell, "Query loading failed", 
          "Please load a model into the Query Results view before loading queries!");
      }
    }
    return null;
  }
}
