/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class HintsPropertySource implements IPropertySource {
  private final QueryEvaluationHint hint;
  
  public HintsPropertySource(final QueryEvaluationHint hint) {
    this.hint = hint;
  }
  
  @Override
  public Object getEditableValue() {
    return this;
  }
  
  @Override
  public String toString() {
    Map<String, Object> _backendHints = this.hint.getBackendHints();
    boolean _isEmpty = _backendHints.isEmpty();
    if (_isEmpty) {
      return "No hints specified";
    }
    return "";
  }
  
  @Override
  public IPropertyDescriptor[] getPropertyDescriptors() {
    final String category = "Hints";
    final List<IPropertyDescriptor> hints = Lists.<IPropertyDescriptor>newArrayList();
    Map<String, Object> _backendHints = this.hint.getBackendHints();
    Set<String> _keySet = _backendHints.keySet();
    final Procedure1<String> _function = new Procedure1<String>() {
      @Override
      public void apply(final String key) {
        final PropertyDescriptor property = new PropertyDescriptor(key, key);
        property.setCategory(category);
        hints.add(property);
      }
    };
    IterableExtensions.<String>forEach(_keySet, _function);
    IPropertyDescriptor[] _newArrayOfSize = new IPropertyDescriptor[0];
    return hints.<IPropertyDescriptor>toArray(_newArrayOfSize);
  }
  
  @Override
  public Object getPropertyValue(final Object id) {
    Map<String, Object> _backendHints = this.hint.getBackendHints();
    final Object hintValue = _backendHints.get(id);
    return hintValue;
  }
  
  @Override
  public boolean isPropertySet(final Object id) {
    return false;
  }
  
  @Override
  public void resetPropertyValue(final Object id) {
  }
  
  @Override
  public void setPropertyValue(final Object id, final Object value) {
  }
}
