/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.index;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.registry.connector.AbstractRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.IPatternBasedSpecificationProvider;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.notification.IStateChangeEventBroker;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class XtextIndexBasedRegistryUpdater {
    public static final String DYNAMIC_CONNECTOR_ID_PREFIX = "dynamic:";
    private final IStateChangeEventBroker source;
    private final IResourceDescriptions descriptions;
    private final IResourceSetProvider resourceSetProvider;
    private final QueryRegistryUpdaterListener listener;
    private final Map<String, PatternDescriptionBasedSourceConnector> connectorMap;
    private final WorkspaceBuildCompletedListener workspaceListener;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IQuerySpecificationRegistry connectedRegistry;
    private Map<IProject, ResourceSet> resourceSetMap = new WeakHashMap<IProject, ResourceSet>();

    @Inject
    public XtextIndexBasedRegistryUpdater(IStateChangeEventBroker source, IResourceDescriptions descriptions, IResourceSetProvider resSetProvider) {
        TreeMap _newTreeMap;
        QueryRegistryUpdaterListener _queryRegistryUpdaterListener;
        WorkspaceBuildCompletedListener _workspaceBuildCompletedListener;
        this.source = source;
        this.descriptions = descriptions;
        this.resourceSetProvider = resSetProvider;
        this.workspaceListener = _workspaceBuildCompletedListener = new WorkspaceBuildCompletedListener(this);
        this.listener = _queryRegistryUpdaterListener = new QueryRegistryUpdaterListener(this);
        this.connectorMap = _newTreeMap = Maps.newTreeMap();
    }

    public void connectIndexToRegistry(final IQuerySpecificationRegistry registry) {
        boolean _equals = Objects.equal((Object)this.connectedRegistry, null);
        if (_equals) {
            this.connectedRegistry = registry;
            Iterable _allResourceDescriptions = this.descriptions.getAllResourceDescriptions();
            Procedures.Procedure1<IResourceDescription> _function = new Procedures.Procedure1<IResourceDescription>(){

                public void apply(final IResourceDescription resourceDesc) {
                    boolean _not;
                    URI _uRI = resourceDesc.getURI();
                    boolean _isPlatformResource = _uRI.isPlatformResource();
                    boolean bl = _not = !_isPlatformResource;
                    if (_not) {
                        return;
                    }
                    Iterable patternObjects = resourceDesc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN);
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)patternObjects);
                    if (_isEmpty) {
                        return;
                    }
                    URI _uRI_1 = resourceDesc.getURI();
                    final String uri = _uRI_1.toString();
                    URI _uRI_2 = resourceDesc.getURI();
                    String projectName = _uRI_2.segment(1);
                    IWorkspace _workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot _root = _workspace.getRoot();
                    IProject project = _root.getProject(projectName);
                    boolean projectExists = project.exists();
                    if (!projectExists || !project.isOpen()) {
                        return;
                    }
                    String connectorId = XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX + projectName;
                    PatternDescriptionBasedSourceConnector connector = (PatternDescriptionBasedSourceConnector)((Object)XtextIndexBasedRegistryUpdater.this.connectorMap.get(connectorId));
                    boolean _equals = Objects.equal((Object)((Object)connector), null);
                    if (_equals) {
                        PatternDescriptionBasedSourceConnector _patternDescriptionBasedSourceConnector;
                        connector = _patternDescriptionBasedSourceConnector = new PatternDescriptionBasedSourceConnector(connectorId);
                        XtextIndexBasedRegistryUpdater.this.connectorMap.put(connectorId, connector);
                    }
                    final PatternDescriptionBasedSourceConnector conn = connector;
                    final ResourceSet resourceSet = XtextIndexBasedRegistryUpdater.this.createResourceSet(projectName);
                    Procedures.Procedure1<IEObjectDescription> _function = new Procedures.Procedure1<IEObjectDescription>(){

                        public void apply(IEObjectDescription it) {
                            PatternDescriptionBasedSpecificationProvider provider = new PatternDescriptionBasedSpecificationProvider(XtextIndexBasedRegistryUpdater.this, resourceDesc, it, resourceSet);
                            conn.addProvider(uri, provider);
                        }
                    };
                    IterableExtensions.forEach((Iterable)patternObjects, (Procedures.Procedure1)_function);
                }
            };
            IterableExtensions.forEach((Iterable)_allResourceDescriptions, (Procedures.Procedure1)_function);
            Collection<PatternDescriptionBasedSourceConnector> _values = this.connectorMap.values();
            Procedures.Procedure1<PatternDescriptionBasedSourceConnector> _function_1 = new Procedures.Procedure1<PatternDescriptionBasedSourceConnector>(){

                public void apply(PatternDescriptionBasedSourceConnector connector) {
                    registry.addSource((IRegistrySourceConnector)connector);
                }
            };
            IterableExtensions.forEach(_values, (Procedures.Procedure1)_function_1);
            this.source.addListener((IResourceDescription.Event.Listener)this.listener);
            IWorkspace _workspace = ResourcesPlugin.getWorkspace();
            _workspace.addResourceChangeListener((IResourceChangeListener)this.workspaceListener);
        }
    }

    public IQuerySpecificationRegistry disconnectIndexFromRegistry() {
        boolean _notEquals;
        Object _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)this.connectedRegistry, null);
        if (_notEquals) {
            Object _xblockexpression = null;
            Collection<PatternDescriptionBasedSourceConnector> _values = this.connectorMap.values();
            Procedures.Procedure1<PatternDescriptionBasedSourceConnector> _function = new Procedures.Procedure1<PatternDescriptionBasedSourceConnector>(){

                public void apply(PatternDescriptionBasedSourceConnector it) {
                    XtextIndexBasedRegistryUpdater.this.connectedRegistry.removeSource((IRegistrySourceConnector)it);
                }
            };
            IterableExtensions.forEach(_values, (Procedures.Procedure1)_function);
            this.source.removeListener((IResourceDescription.Event.Listener)this.listener);
            this.connectorMap.clear();
            this.connectedRegistry = null;
            _xifexpression = _xblockexpression = null;
        }
        return _xifexpression;
    }

    public ResourceSet createResourceSet(String projectName) {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = _workspace.getRoot();
        IProject project = root.getProject(projectName);
        ResourceSet resourceSet = this.resourceSetProvider.get(project);
        return resourceSet;
    }

    @Pure
    protected IQuerySpecificationRegistry getConnectedRegistry() {
        return this.connectedRegistry;
    }

    private static final class PatternDescriptionBasedSourceConnector
    extends AbstractRegistrySourceConnector {
        private final Multimap<String, IQuerySpecificationProvider> descriptionToProvider;

        public PatternDescriptionBasedSourceConnector(String identifier) {
            super(identifier, false);
            HashMultimap _create;
            this.descriptionToProvider = _create = HashMultimap.create();
        }

        public void addProvider(String resourceUri, final PatternDescriptionBasedSpecificationProvider provider) {
            this.descriptionToProvider.put((Object)resourceUri, (Object)provider);
            Procedures.Procedure1<IConnectorListener> _function = new Procedures.Procedure1<IConnectorListener>(){

                public void apply(IConnectorListener it) {
                    it.querySpecificationAdded((IRegistrySourceConnector)PatternDescriptionBasedSourceConnector.this, (IQuerySpecificationProvider)provider);
                }
            };
            IterableExtensions.forEach((Iterable)this.listeners, (Procedures.Procedure1)_function);
        }

        public Collection<IQuerySpecificationProvider> clearProviders(String resourceUri) {
            Collection _xblockexpression = null;
            Collection _get = this.descriptionToProvider.get((Object)resourceUri);
            Procedures.Procedure1<IQuerySpecificationProvider> _function = new Procedures.Procedure1<IQuerySpecificationProvider>(){

                public void apply(final IQuerySpecificationProvider provider) {
                    Procedures.Procedure1<IConnectorListener> _function = new Procedures.Procedure1<IConnectorListener>(){

                        public void apply(IConnectorListener it) {
                            it.querySpecificationRemoved((IRegistrySourceConnector)PatternDescriptionBasedSourceConnector.this, provider);
                        }
                    };
                    IterableExtensions.forEach((Iterable)PatternDescriptionBasedSourceConnector.this.listeners, (Procedures.Procedure1)_function);
                }
            };
            IterableExtensions.forEach((Iterable)_get, (Procedures.Procedure1)_function);
            _xblockexpression = this.descriptionToProvider.removeAll((Object)resourceUri);
            return _xblockexpression;
        }

        protected void sendQuerySpecificationsToListener(final IConnectorListener listener) {
            Collection _values = this.descriptionToProvider.values();
            Procedures.Procedure1<IQuerySpecificationProvider> _function = new Procedures.Procedure1<IQuerySpecificationProvider>(){

                public void apply(IQuerySpecificationProvider it) {
                    listener.querySpecificationAdded((IRegistrySourceConnector)PatternDescriptionBasedSourceConnector.this, it);
                }
            };
            IterableExtensions.forEach((Iterable)_values, (Procedures.Procedure1)_function);
        }
    }

    @FinalFieldsConstructor
    private static final class PatternDescriptionBasedSpecificationProvider
    implements IPatternBasedSpecificationProvider {
        private final XtextIndexBasedRegistryUpdater updater;
        private final IResourceDescription resourceDesc;
        private final IEObjectDescription description;
        private final ResourceSet resourceSet;
        private IQuerySpecification<?> specification;

        public String getFullyQualifiedName() {
            QualifiedName _qualifiedName = this.description.getQualifiedName();
            return _qualifiedName.toString();
        }

        public IQuerySpecification<?> get() {
            try {
                boolean _equals = Objects.equal(this.specification, null);
                if (_equals) {
                    IQuerySpecification _orCreateSpecification;
                    Pattern pattern = this.findPatternForDescription();
                    SpecificationBuilder builder = new SpecificationBuilder();
                    this.specification = _orCreateSpecification = builder.getOrCreateSpecification(pattern);
                }
                return this.specification;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        @Override
        public IQuerySpecification<?> getSpecification(SpecificationBuilder builder) {
            try {
                Pattern pattern = this.findPatternForDescription();
                IQuerySpecification spec = builder.getOrCreateSpecification(pattern);
                return spec;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public Pattern findPatternForDescription() {
            boolean _eIsProxy_1;
            EObject pattern = this.description.getEObjectOrProxy();
            boolean _eIsProxy = pattern.eIsProxy();
            if (_eIsProxy) {
                EObject _resolve;
                pattern = _resolve = EcoreUtil.resolve((EObject)pattern, (ResourceSet)this.resourceSet);
            }
            if (_eIsProxy_1 = pattern.eIsProxy()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Cannot load specification ");
                String _fullyQualifiedName = this.getFullyQualifiedName();
                _builder.append((Object)_fullyQualifiedName, "");
                _builder.append((Object)" from Xtext index");
                throw new IllegalStateException(_builder.toString());
            }
            return (Pattern)pattern;
        }

        public String getSourceProjectName() {
            URI _uRI = this.resourceDesc.getURI();
            return _uRI.segment(1);
        }

        @Override
        public URI getSpecificationSourceURI() {
            return this.description.getEObjectURI();
        }

        public PatternDescriptionBasedSpecificationProvider(XtextIndexBasedRegistryUpdater updater, IResourceDescription resourceDesc, IEObjectDescription description, ResourceSet resourceSet) {
            this.updater = updater;
            this.resourceDesc = resourceDesc;
            this.description = description;
            this.resourceSet = resourceSet;
        }
    }

    @FinalFieldsConstructor
    private static final class QueryRegistryUpdaterListener
    implements IResourceDescription.Event.Listener {
        private final XtextIndexBasedRegistryUpdater updater;

        public void descriptionsChanged(IResourceDescription.Event event) {
            ImmutableList _deltas = event.getDeltas();
            Procedures.Procedure1<IResourceDescription.Delta> _function = new Procedures.Procedure1<IResourceDescription.Delta>(){

                public void apply(IResourceDescription.Delta delta) {
                    boolean _not;
                    IResourceDescription oldDesc = delta.getOld();
                    IResourceDescription newDesc = delta.getNew();
                    URI _uri = delta.getUri();
                    String uri = _uri.toString();
                    URI _uri_1 = delta.getUri();
                    boolean _isPlatformResource = _uri_1.isPlatformResource();
                    boolean bl = _not = !_isPlatformResource;
                    if (_not) {
                        return;
                    }
                    URI _uri_2 = delta.getUri();
                    String projectName = _uri_2.segment(1);
                    IWorkspace _workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot _root = _workspace.getRoot();
                    IProject project = _root.getProject(projectName);
                    boolean projectExists = project.exists();
                    if (!projectExists) {
                        return;
                    }
                    String connectorId = XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX + projectName;
                    try {
                        boolean _notEquals;
                        boolean bl2 = _notEquals = !Objects.equal((Object)oldDesc, null);
                        if (_notEquals) {
                            if (Objects.equal((Object)newDesc, null) || !project.isOpen()) {
                                boolean _notEquals_1;
                                PatternDescriptionBasedSourceConnector connector = (PatternDescriptionBasedSourceConnector)((Object)QueryRegistryUpdaterListener.this.updater.connectorMap.get(connectorId));
                                boolean bl3 = _notEquals_1 = !Objects.equal((Object)((Object)connector), null);
                                if (_notEquals_1) {
                                    connector.clearProviders(uri);
                                    boolean _isEmpty = connector.descriptionToProvider.isEmpty();
                                    if (_isEmpty) {
                                        QueryRegistryUpdaterListener.this.updater.connectedRegistry.removeSource((IRegistrySourceConnector)connector);
                                        QueryRegistryUpdaterListener.this.updater.connectorMap.remove(connectorId);
                                    }
                                }
                            } else {
                                QueryRegistryUpdaterListener.this.processResourceDescription(delta, newDesc, connectorId, projectName);
                            }
                        } else if (!Objects.equal((Object)newDesc, null) && !IterableExtensions.isEmpty((Iterable)newDesc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN))) {
                            QueryRegistryUpdaterListener.this.processResourceDescription(delta, newDesc, connectorId, projectName);
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception ex = (Exception)_t;
                            Logger logger = ViatraQueryLoggingUtil.getLogger(XtextIndexBasedRegistryUpdater.class);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Could not update registry based on Xtext index for ");
                            _builder.append((Object)uri, "");
                            logger.error((Object)_builder, (Throwable)ex);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)_deltas, (Procedures.Procedure1)_function);
        }

        public Object processResourceDescription(IResourceDescription.Delta delta, final IResourceDescription desc, String connectorId, String projectName) {
            Object _xifexpression = null;
            boolean _containsKey = this.updater.connectorMap.containsKey(connectorId);
            if (_containsKey) {
                URI _uRI = desc.getURI();
                _xifexpression = this.updater.workspaceListener.connectorsToUpdate.put(_uRI, desc);
            } else {
                boolean _not;
                boolean _xifexpression_1 = false;
                Iterable _exportedObjectsByType = desc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_exportedObjectsByType);
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    boolean _xblockexpression = false;
                    final PatternDescriptionBasedSourceConnector connector = new PatternDescriptionBasedSourceConnector(connectorId);
                    this.updater.connectorMap.put(connectorId, connector);
                    boolean _haveEObjectDescriptionsChanged = delta.haveEObjectDescriptionsChanged();
                    if (_haveEObjectDescriptionsChanged) {
                        final ResourceSet resourceSet = this.updater.createResourceSet(projectName);
                        Iterable _exportedObjectsByType_1 = desc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN);
                        Procedures.Procedure1<IEObjectDescription> _function = new Procedures.Procedure1<IEObjectDescription>(){

                            public void apply(IEObjectDescription it) {
                                PatternDescriptionBasedSpecificationProvider provider = new PatternDescriptionBasedSpecificationProvider(QueryRegistryUpdaterListener.this.updater, desc, it, resourceSet);
                                URI _uRI = desc.getURI();
                                String _string = _uRI.toString();
                                connector.addProvider(_string, provider);
                            }
                        };
                        IterableExtensions.forEach((Iterable)_exportedObjectsByType_1, (Procedures.Procedure1)_function);
                    }
                    _xifexpression_1 = _xblockexpression = this.updater.connectedRegistry.addSource((IRegistrySourceConnector)connector);
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        }

        public QueryRegistryUpdaterListener(XtextIndexBasedRegistryUpdater updater) {
            this.updater = updater;
        }
    }

    @FinalFieldsConstructor
    private static final class WorkspaceBuildCompletedListener
    implements IResourceChangeListener {
        private final Map<URI, IResourceDescription> connectorsToUpdate = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        private final XtextIndexBasedRegistryUpdater updater;

        public void resourceChanged(IResourceChangeEvent event) {
            int type = event.getType();
            if (type == 1) {
                boolean _isEmpty = this.connectorsToUpdate.isEmpty();
                if (_isEmpty) {
                    return;
                }
                ImmutableMap update = ImmutableMap.copyOf(this.connectorsToUpdate);
                Procedures.Procedure2<URI, IResourceDescription> _function = new Procedures.Procedure2<URI, IResourceDescription>(){

                    public void apply(final URI uri, final IResourceDescription descr) {
                        try {
                            WorkspaceBuildCompletedListener.this.connectorsToUpdate.remove(uri);
                            String projectName = uri.segment(1);
                            String connectorId = XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX + projectName;
                            final PatternDescriptionBasedSourceConnector connector = (PatternDescriptionBasedSourceConnector)((Object)WorkspaceBuildCompletedListener.this.updater.connectorMap.get(connectorId));
                            String _string = uri.toString();
                            connector.clearProviders(_string);
                            final ResourceSet resourceSet = WorkspaceBuildCompletedListener.this.updater.createResourceSet(projectName);
                            Iterable patternObjects = descr.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN);
                            Procedures.Procedure1<IEObjectDescription> _function = new Procedures.Procedure1<IEObjectDescription>(){

                                public void apply(IEObjectDescription it) {
                                    PatternDescriptionBasedSpecificationProvider provider = new PatternDescriptionBasedSpecificationProvider(WorkspaceBuildCompletedListener.this.updater, descr, it, resourceSet);
                                    String _string = uri.toString();
                                    connector.addProvider(_string, provider);
                                }
                            };
                            IterableExtensions.forEach((Iterable)patternObjects, (Procedures.Procedure1)_function);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Exception) {
                                Exception ex = (Exception)_t;
                                Logger logger = ViatraQueryLoggingUtil.getLogger(XtextIndexBasedRegistryUpdater.class);
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"Could not update registry based on Xtext index for ");
                                _builder.append((Object)uri, "");
                                logger.error((Object)_builder, (Throwable)ex);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                };
                MapExtensions.forEach((Map)update, (Procedures.Procedure2)_function);
            }
        }

        public WorkspaceBuildCompletedListener(XtextIndexBasedRegistryUpdater updater) {
            this.updater = updater;
        }
    }
}

