/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeLabelProvider;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultViewModel;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.ViatraQueryEngineContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.ViatraQueryEngineLabelProvider;
import org.eclipse.viatra.query.tooling.ui.util.CommandInvokingDoubleClickListener;
import org.eclipse.viatra.query.tooling.ui.util.IModelConnectorListener;

public class QueryResultView
extends ViewPart {
    @Inject
    private Injector injector;
    private static final String SCOPE_UNINITIALIZED_MSG = "Scope uninitialized!\r\nPress the \"Load model from active editor\" button on the toolbar!";
    public static final String ID = "org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView";
    private TreeViewer queryResultTreeViewer;
    private QueryResultTreeInput input;
    private Label lblScopeDescription;
    private ITabbedPropertySheetPageContributor propertyPageContributor = new ITabbedPropertySheetPageContributor(){

        public String getContributorId() {
            return QueryResultView.this.getSite().getId();
        }
    };
    private QueryEvaluationHint hint = new QueryEvaluationHint((IQueryBackendFactory)new ReteBackendFactory(), new HashMap());
    private CollapseAllHandler collapseHandler;
    private IModelConnectorListener connectorListener = new IModelConnectorListener(){

        public void modelUnloaded(IModelConnector modelConnector) {
            QueryResultView.this.unloadModel();
        }
    };
    private TreeViewer engineDetailsTreeViewer;
    private StackLayout engineDetailsStackLayout;

    public void createPartControl(Composite parent) {
        CommandInvokingDoubleClickListener showLocationListener = new CommandInvokingDoubleClickListener("org.eclipse.viatra.query.tooling.ui.showlocation", "Exception when activating show location!");
        this.injector.injectMembers((Object)showLocationListener);
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance()};
        SashForm sashForm = new SashForm(parent, 512);
        Group grpScope = new Group((Composite)sashForm, 0);
        grpScope.setText("Engine details");
        this.engineDetailsStackLayout = new StackLayout();
        grpScope.setLayout((Layout)this.engineDetailsStackLayout);
        this.engineDetailsTreeViewer = new TreeViewer((Composite)grpScope, 2048);
        this.engineDetailsTreeViewer.setLabelProvider((IBaseLabelProvider)new ViatraQueryEngineLabelProvider());
        this.engineDetailsTreeViewer.setContentProvider((IContentProvider)new ViatraQueryEngineContentProvider());
        this.lblScopeDescription = new Label((Composite)grpScope, 64);
        this.lblScopeDescription.setText(SCOPE_UNINITIALIZED_MSG);
        this.engineDetailsStackLayout.topControl = this.lblScopeDescription;
        this.queryResultTreeViewer = new TreeViewer((Composite)sashForm, 2050);
        this.queryResultTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof QueryResultTreeMatcher && e2 instanceof QueryResultTreeMatcher) {
                    return super.compare(viewer, e1, e2);
                }
                if (e1 instanceof IPatternMatch && e2 instanceof IPatternMatch) {
                    return super.compare(viewer, e1, e2);
                }
                return 0;
            }
        });
        this.queryResultTreeViewer.setLabelProvider((IBaseLabelProvider)new QueryResultTreeLabelProvider());
        this.queryResultTreeViewer.setContentProvider((IContentProvider)new QueryResultTreeContentProvider());
        this.queryResultTreeViewer.addDoubleClickListener((IDoubleClickListener)showLocationListener);
        this.queryResultTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (parentElement instanceof QueryResultTreeMatcher && element instanceof IPatternMatch) {
                    QueryResultTreeMatcher queryResultTreeMatcher = (QueryResultTreeMatcher)parentElement;
                    IPatternMatch patternMatch = (IPatternMatch)element;
                    boolean compatibleWith = queryResultTreeMatcher.getFilterMatch().isCompatibleWith(patternMatch);
                    return compatibleWith;
                }
                return true;
            }
        });
        this.queryResultTreeViewer.addDropSupport(operations, transferTypes, (DropTargetListener)new ViewerDropAdapter((Viewer)this.queryResultTreeViewer){

            public boolean performDrop(Object data) {
                boolean active;
                if (data instanceof IStructuredSelection && (active = QueryResultView.this.hasActiveEngine())) {
                    Set<QueryRegistryTreeEntry> selectedQueries = QueryResultViewUtil.getRegistryEntriesFromSelection((IStructuredSelection)data);
                    for (QueryRegistryTreeEntry queryRegistryTreeEntry : selectedQueries) {
                        queryRegistryTreeEntry.load();
                    }
                    QueryResultView.this.loadQueriesIntoActiveEngine(QueryResultViewUtil.unwrapEntries(selectedQueries));
                    return true;
                }
                return false;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                boolean active = QueryResultView.this.hasActiveEngine();
                boolean supportedType = LocalTransfer.getInstance().isSupportedType(transferType);
                return active && supportedType;
            }
        });
        sashForm.setWeights(new int[]{1, 4});
        this.getSite().setSelectionProvider((ISelectionProvider)this.queryResultTreeViewer);
        Control control = this.queryResultTreeViewer.getControl();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        control.setMenu(menuManager.createContextMenu(control));
        this.getSite().registerContextMenu(ID, menuManager, (ISelectionProvider)this.queryResultTreeViewer);
        this.collapseHandler = new CollapseAllHandler((AbstractTreeViewer)this.queryResultTreeViewer);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseHandler);
    }

    public void dispose() {
        this.collapseHandler.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.queryResultTreeViewer.getTree().setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage(this.propertyPageContributor));
        }
        return super.getAdapter(adapter);
    }

    private void loadEngineDetails(AdvancedViatraQueryEngine engine) {
        this.engineDetailsTreeViewer.setInput((Object)engine);
        this.engineDetailsStackLayout.topControl = this.engineDetailsTreeViewer.getTree();
        this.requestLayoutInternal(this.engineDetailsTreeViewer.getControl());
    }

    private void removeEngineDetails() {
        this.engineDetailsStackLayout.topControl = this.lblScopeDescription;
        this.engineDetailsTreeViewer.setInput(null);
        this.requestLayoutInternal((Control)this.lblScopeDescription);
    }

    private void requestLayoutInternal(Control control) {
        control.getShell().layout(new Control[]{control}, 4);
    }

    public void loadModel(EMFModelConnector modelConnector, IModelConnectorTypeEnum scope) throws ViatraQueryException {
        this.unloadModel();
        this.input = QueryResultViewModel.INSTANCE.createInput((IModelConnector)modelConnector, scope);
        this.input.setHint(this.hint);
        this.queryResultTreeViewer.setInput((Object)this.input);
        modelConnector.addListener(this.connectorListener);
        this.loadEngineDetails(this.input.getEngine());
        this.activeEnginePropertyChanged();
    }

    public void loadExistingEngine(AdvancedViatraQueryEngine engine) {
        this.unloadModel();
        this.input = QueryResultViewModel.INSTANCE.createInput(engine, true);
        this.queryResultTreeViewer.setInput((Object)this.input);
        this.loadEngineDetails(engine);
        this.activeEnginePropertyChanged();
    }

    private void activeEnginePropertyChanged() {
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        if (service != null) {
            service.requestEvaluation("org.eclipse.viatra.query.tooling.ui.browser.result.activeengine");
        }
    }

    public void unloadModel() {
        if (this.input != null) {
            QueryResultViewModel.INSTANCE.removeInput(this.input);
            if (this.input.getModelConnector() instanceof EMFModelConnector) {
                EMFModelConnector emfModelConnector = (EMFModelConnector)this.input.getModelConnector();
                emfModelConnector.removeListener(this.connectorListener);
            }
            this.input = null;
            if (!this.queryResultTreeViewer.getControl().isDisposed()) {
                this.queryResultTreeViewer.setInput(null);
                this.removeEngineDetails();
            }
            this.activeEnginePropertyChanged();
        }
    }

    public void loadQueriesIntoActiveEngine(Iterable<IQuerySpecificationRegistryEntry> providers) {
        if (!this.input.isReadOnlyEngine()) {
            this.input.loadQueries(providers);
        }
    }

    public boolean hasActiveEngine() {
        return this.input != null;
    }

    public void wipeEngine() {
        if (this.input != null && !this.input.isReadOnlyEngine()) {
            this.input.resetInput();
        }
    }

    public QueryEvaluationHint getHint() {
        if (this.input != null) {
            return this.input.getHint();
        }
        return this.hint;
    }

    public void setHint(QueryEvaluationHint hint) {
        this.hint = hint;
        if (this.input != null) {
            this.input.setHint(hint);
        }
    }

    public IModelConnector getModelConnector() {
        if (this.input != null) {
            return this.input.getModelConnector();
        }
        return null;
    }
}

