/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.XtextIndexBasedRegistryUpdaterFactory;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LoadVqlPatternHandler
extends AbstractHandler {
    @Inject
    Injector injector;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        IWorkbenchSite _activeSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        IWorkbenchPage _page = _activeSite.getPage();
        IViewPart resultView = _page.findView("org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView");
        if (resultView instanceof QueryResultView) {
            QueryResultView queryResultView = (QueryResultView)resultView;
            boolean active = queryResultView.hasActiveEngine();
            if (active && editorPart instanceof XtextEditor) {
                XtextEditor xtextEditor = (XtextEditor)editorPart;
                IResource resource = xtextEditor.getResource();
                IProject _project = resource.getProject();
                String _name = _project.getName();
                final String sourceId = "dynamic:" + _name;
                IXtextDocument _document = xtextEditor.getDocument();
                IUnitOfWork<Iterable<String>, XtextResource> _function = new IUnitOfWork<Iterable<String>, XtextResource>(){

                    public Iterable<String> exec(XtextResource state) throws Exception {
                        EList _contents = state.getContents();
                        Iterable _filter = Iterables.filter((Iterable)_contents, PatternModel.class);
                        Functions.Function1<PatternModel, EList<Pattern>> _function = new Functions.Function1<PatternModel, EList<Pattern>>(){

                            public EList<Pattern> apply(PatternModel it) {
                                return it.getPatterns();
                            }
                        };
                        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
                        Iterable _flatten = Iterables.concat((Iterable)_map);
                        Functions.Function1<Pattern, String> _function_1 = new Functions.Function1<Pattern, String>(){

                            public String apply(Pattern it) {
                                return CorePatternLanguageHelper.getFullyQualifiedName((Pattern)it);
                            }
                        };
                        Iterable fqns = IterableExtensions.map((Iterable)_flatten, (Functions.Function1)_function_1);
                        return fqns;
                    }
                };
                final Iterable patternFQNs = (Iterable)_document.readOnly((IUnitOfWork)_function);
                IQuerySpecificationRegistry _instance = QuerySpecificationRegistry.getInstance();
                XtextIndexBasedRegistryUpdaterFactory.INSTANCE.getUpdater(_instance);
                IQuerySpecificationRegistry _instance_1 = QuerySpecificationRegistry.getInstance();
                IRegistryViewFilter _function_1 = new IRegistryViewFilter(){

                    public boolean isEntryRelevant(final IQuerySpecificationRegistryEntry entry) {
                        String _sourceIdentifier = entry.getSourceIdentifier();
                        boolean sourceSame = Objects.equal((Object)_sourceIdentifier, (Object)sourceId);
                        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                            public Boolean apply(String it) {
                                String _fullyQualifiedName = entry.getFullyQualifiedName();
                                return Objects.equal((Object)it, (Object)_fullyQualifiedName);
                            }
                        };
                        boolean fqnRelevant = IterableExtensions.exists((Iterable)patternFQNs, (Functions.Function1)_function);
                        return sourceSame && fqnRelevant;
                    }
                };
                IRegistryView view = _instance_1.createView(_function_1);
                Iterable _entries = view.getEntries();
                queryResultView.loadQueriesIntoActiveEngine(_entries);
            } else {
                IWorkbenchPartSite _site = queryResultView.getSite();
                Shell _shell = _site.getShell();
                MessageDialog.openError((Shell)_shell, (String)"Query loading failed", (String)"Please load a model into the Query Results view before loading queries!");
            }
        }
        return null;
    }
}

