/**
 * Copyright (c) 2010-2016, Peter Lunk, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Peter Lunk - initial API and implementation
 */
package org.eclipse.viatra.transformation.debug.transformationtrace.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.transformation.debug.transformationtrace.transformationtrace.ActivationTrace;
import org.eclipse.viatra.transformation.debug.transformationtrace.transformationtrace.RuleParameterTrace;

@SuppressWarnings("all")
public class ActivationTraceUtil {
  public static boolean compareActivationCodes(final ActivationTrace a1, final ActivationTrace a2) {
    boolean retVal = false;
    EList<RuleParameterTrace> a1RuleParameterTraces = a1.getRuleParameterTraces();
    EList<RuleParameterTrace> a2ruleParameterTraces = a2.getRuleParameterTraces();
    int _size = a1RuleParameterTraces.size();
    int _size_1 = a2ruleParameterTraces.size();
    boolean _equals = (_size == _size_1);
    if (_equals) {
      boolean temp = true;
      for (int i = 0; (i < a1RuleParameterTraces.size()); i++) {
        {
          RuleParameterTrace a1Trace = a1RuleParameterTraces.get(i);
          RuleParameterTrace a2Trace = a2ruleParameterTraces.get(i);
          if (((!a1Trace.getParameterName().equals(a2Trace.getParameterName())) || 
            (!a1Trace.getObjectId().equals(a2Trace.getObjectId())))) {
            temp = false;
          }
        }
      }
      retVal = temp;
      return retVal;
    }
    return false;
  }
}
