/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.transformation.views.traceability.patterns;

import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.transformation.views.traceability.patterns.EmptyTraceMatcher;
import org.eclipse.viatra.transformation.views.traceability.patterns.Param2targetMatcher;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2objectMatcher;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2paramMatcher;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2targetMatcher;
import org.eclipse.viatra.transformation.views.traceability.patterns.TraceMatcher;
import org.eclipse.viatra.transformation.views.traceability.patterns.util.EmptyTraceQuerySpecification;
import org.eclipse.viatra.transformation.views.traceability.patterns.util.Param2targetQuerySpecification;
import org.eclipse.viatra.transformation.views.traceability.patterns.util.Trace2objectQuerySpecification;
import org.eclipse.viatra.transformation.views.traceability.patterns.util.Trace2paramQuerySpecification;
import org.eclipse.viatra.transformation.views.traceability.patterns.util.Trace2targetQuerySpecification;
import org.eclipse.viatra.transformation.views.traceability.patterns.util.TraceQuerySpecification;

/**
 * A pattern group formed of all patterns defined in helpers.vql.
 * 
 * <p>Use the static instance as any {@link org.eclipse.viatra.query.runtime.api.IPatternGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file helpers.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.transformation.views.traceability.patterns, the group contains the definition of the following patterns: <ul>
 * <li>emptyTrace</li>
 * <li>traceTargets</li>
 * <li>trace2target</li>
 * <li>trace2param</li>
 * <li>trace2object</li>
 * <li>param2target</li>
 * <li>trace</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class Helpers extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static Helpers instance() throws ViatraQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new Helpers();
    }
    return INSTANCE;
  }
  
  private static Helpers INSTANCE;
  
  private Helpers() throws ViatraQueryException {
    querySpecifications.add(EmptyTraceQuerySpecification.instance());
    querySpecifications.add(Trace2targetQuerySpecification.instance());
    querySpecifications.add(Trace2paramQuerySpecification.instance());
    querySpecifications.add(Trace2objectQuerySpecification.instance());
    querySpecifications.add(Param2targetQuerySpecification.instance());
    querySpecifications.add(TraceQuerySpecification.instance());
  }
  
  public EmptyTraceQuerySpecification getEmptyTrace() throws ViatraQueryException {
    return EmptyTraceQuerySpecification.instance();
  }
  
  public EmptyTraceMatcher getEmptyTrace(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EmptyTraceMatcher.on(engine);
  }
  
  public Trace2targetQuerySpecification getTrace2target() throws ViatraQueryException {
    return Trace2targetQuerySpecification.instance();
  }
  
  public Trace2targetMatcher getTrace2target(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Trace2targetMatcher.on(engine);
  }
  
  public Trace2paramQuerySpecification getTrace2param() throws ViatraQueryException {
    return Trace2paramQuerySpecification.instance();
  }
  
  public Trace2paramMatcher getTrace2param(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Trace2paramMatcher.on(engine);
  }
  
  public Trace2objectQuerySpecification getTrace2object() throws ViatraQueryException {
    return Trace2objectQuerySpecification.instance();
  }
  
  public Trace2objectMatcher getTrace2object(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Trace2objectMatcher.on(engine);
  }
  
  public Param2targetQuerySpecification getParam2target() throws ViatraQueryException {
    return Param2targetQuerySpecification.instance();
  }
  
  public Param2targetMatcher getParam2target(final ViatraQueryEngine engine) throws ViatraQueryException {
    return Param2targetMatcher.on(engine);
  }
  
  public TraceQuerySpecification getTrace() throws ViatraQueryException {
    return TraceQuerySpecification.instance();
  }
  
  public TraceMatcher getTrace(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TraceMatcher.on(engine);
  }
}
