/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime.util.validation;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.handler.QueryBasedFeatures;
import org.eclipse.viatra.query.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeSystem;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Annotation;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Expression;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.StringValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Variable;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.viatra.query.patternlanguage.typing.ITypeInferrer;
import org.eclipse.viatra.query.patternlanguage.validation.IIssueCallback;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;

public class QueryBasedFeaturePatternValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.viatra.addon.querybasedfeatures.";
    public static final String GENERAL_ISSUE_CODE = "org.eclipse.viatra.addon.querybasedfeatures.general";
    public static final String METAMODEL_ISSUE_CODE = "org.eclipse.viatra.addon.querybasedfeatures.faulty_metamodel";
    public static final String PATTERN_ISSUE_CODE = "org.eclipse.viatra.addon.querybasedfeatures.faulty_pattern";
    public static final String ANNOTATION_ISSUE_CODE = "org.eclipse.viatra.addon.querybasedfeatures.faulty_annotation";
    @Inject
    private ITypeInferrer typeInferrer;

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        EPackage ePackage;
        URI uri;
        boolean keepCache;
        EClassifier classifier;
        boolean foundErrors = false;
        Pattern pattern = (Pattern)annotation.eContainer();
        foundErrors = this.checkFeatureUniquenessOnQBFAnnotations(annotation, validator, pattern);
        if (foundErrors) {
            return;
        }
        if (pattern.getParameters().size() < 2) {
            validator.error("Query-based feature pattern must have at least two parameters.", (EObject)pattern, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__PARAMETERS, PATTERN_ISSUE_CODE, new String[0]);
            return;
        }
        Variable source = null;
        ValueReference ref = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"source");
        if (ref == null) {
            source = (Variable)pattern.getParameters().get(0);
        } else if (ref instanceof VariableValue) {
            source = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)((VariableValue)ref).getValue().getVar());
            if (((Variable)pattern.getParameters().get(0)).equals(source)) {
                validator.warning("The 'source' parameter is not needed if it is the first pattern parameter.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE_VALUE__VALUE, ANNOTATION_ISSUE_CODE, new String[0]);
            }
        }
        IInputKey sourceType = null;
        if (source != null) {
            sourceType = this.typeInferrer.getType((Expression)source);
        }
        if (!(sourceType instanceof EClassTransitiveInstancesKey)) {
            validator.error("The 'source' parameter must be EClass.", (EObject)source, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__TYPE, PATTERN_ISSUE_CODE, new String[0]);
            return;
        }
        EClass sourceClass = (EClass)((EClassTransitiveInstancesKey)sourceType).getEmfKey();
        String featureName = null;
        Pattern contextForFeature = null;
        EAttribute contextESFForFeature = null;
        ref = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"feature");
        if (ref == null) {
            featureName = pattern.getName();
            contextForFeature = pattern;
            contextESFForFeature = PatternLanguagePackage.Literals.PATTERN__NAME;
        } else if (ref instanceof StringValue) {
            featureName = ((StringValue)ref).getValue();
            contextForFeature = ref;
            contextESFForFeature = PatternLanguagePackage.Literals.STRING_VALUE__VALUE;
        }
        if (featureName == null || featureName.isEmpty()) {
            validator.error("The 'feature' parameter must not be empty.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, ANNOTATION_ISSUE_CODE, new String[0]);
            return;
        }
        EStructuralFeature feature = null;
        for (EStructuralFeature f : sourceClass.getEStructuralFeatures()) {
            if (!featureName.equals(f.getName())) continue;
            feature = f;
            break;
        }
        if (feature == null) {
            validator.error(String.format("Cannot find feature %s of EClass %s.", featureName, sourceClass.getName()), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, ANNOTATION_ISSUE_CODE, new String[0]);
            return;
        }
        if (feature instanceof EReference) {
            boolean featureError = false;
            if (!feature.isDerived()) {
                validator.error(String.format("Feature %s is not derived.", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
                featureError = true;
            }
            if (!feature.isTransient()) {
                validator.error(String.format("Feature %s is not transient.", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
                featureError = true;
            }
            if (!feature.isVolatile()) {
                validator.error(String.format("Feature %s is not volatile.", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
                featureError = true;
            }
            if (featureError) {
                return;
            }
            if (feature.isChangeable()) {
                validator.warning(String.format("Feature %s is changeable, make sure to implement setter.", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
            }
        }
        if ((classifier = feature.getEGenericType().getEClassifier()) == null) {
            validator.error(String.format("Feature %s has no type information set in the metamodel", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
            return;
        }
        Variable target = null;
        ref = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"target");
        if (ref == null) {
            target = (Variable)pattern.getParameters().get(1);
        } else if (ref instanceof VariableValue) {
            target = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)((VariableValue)ref).getValue().getVar());
            if (((Variable)pattern.getParameters().get(1)).equals(target)) {
                validator.warning("The 'target' parameter is not needed if it is the second pattern parameter.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE_VALUE__VALUE, ANNOTATION_ISSUE_CODE, new String[0]);
            }
        }
        IInputKey targetType = this.typeInferrer.getType((Expression)target);
        EClassifier targetClassifier = (EClassifier)EMFTypeSystem.EXTRACT_CLASSIFIER.apply((Object)targetType);
        if (targetType == null) {
            validator.warning("Cannot find target EClassifier", (EObject)target, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__TYPE, PATTERN_ISSUE_CODE, new String[0]);
        }
        QueryBasedFeatureKind kind = null;
        ref = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"kind");
        if (ref instanceof StringValue) {
            String kindStr = ((StringValue)ref).getValue();
            if (QueryBasedFeatureKind.getStringValue(QueryBasedFeatureKind.SINGLE_REFERENCE).equals(kindStr)) {
                if (feature.getUpperBound() != 1) {
                    validator.error(String.format("Upper bound of feature %s should be 1 for single 'kind'.", featureName), (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, METAMODEL_ISSUE_CODE, new String[0]);
                    return;
                }
                kind = QueryBasedFeatureKind.SINGLE_REFERENCE;
            } else if (QueryBasedFeatureKind.getStringValue(QueryBasedFeatureKind.MANY_REFERENCE).equals(kindStr)) {
                if (feature.getUpperBound() != -1 && feature.getUpperBound() < 2) {
                    validator.error(String.format("Upper bound of feature %s should be -1 or larger than 1 for many 'kind'.", featureName), (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, METAMODEL_ISSUE_CODE, new String[0]);
                    return;
                }
                kind = QueryBasedFeatureKind.MANY_REFERENCE;
            } else if (QueryBasedFeatureKind.getStringValue(QueryBasedFeatureKind.SUM).equals(kindStr)) {
                if (!classifier.equals(EcorePackage.Literals.EINT)) {
                    validator.error(String.format("Type of feature %s should be EInt for %s 'kind'.", featureName, kindStr), (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, METAMODEL_ISSUE_CODE, new String[0]);
                    return;
                }
                kind = QueryBasedFeatureKind.SUM;
            } else if (QueryBasedFeatureKind.getStringValue(QueryBasedFeatureKind.ITERATION).equals(kindStr)) {
                validator.warning("Don't forget to subclass QueryBasedFeature for iteration 'kind'.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, ANNOTATION_ISSUE_CODE, new String[0]);
                kind = QueryBasedFeatureKind.ITERATION;
            }
        }
        if (!(classifier.equals(targetClassifier) || kind != QueryBasedFeatureKind.SINGLE_REFERENCE && kind != QueryBasedFeatureKind.MANY_REFERENCE)) {
            validator.warning(String.format("The 'target' parameter type %s is not equal to actual feature type %s.", featureName, sourceClass.getName()), (EObject)target, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__TYPE, PATTERN_ISSUE_CODE, new String[0]);
        }
        if ((ref = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"keepCache")) instanceof BoolValue && !(keepCache = ((BoolValue)ref).isValue())) {
            switch (kind) {
                case SINGLE_REFERENCE: 
                case MANY_REFERENCE: {
                    break;
                }
                default: {
                    validator.error("Cacheless behavior only available for single and many kinds.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, ANNOTATION_ISSUE_CODE, new String[0]);
                }
            }
        }
        if (!(uri = (ePackage = sourceClass.getEPackage()).eResource().getURI()).isFile() && !uri.isPlatformResource()) {
            String patternFQN;
            boolean annotationsOK;
            ValueReference useModelCodeRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"generateIntoModelCode");
            boolean useModelCode = false;
            if (useModelCodeRef != null) {
                useModelCode = ((BoolValue)useModelCodeRef).isValue();
            }
            if (!(annotationsOK = QueryBasedFeatures.checkEcoreAnnotation(ePackage, feature, patternFQN = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern), useModelCode))) {
                validator.error(String.format("Ecore package of %s must be writable by Query-based Feature generator, but resource with URI %s is not!", sourceClass.getName(), uri.toString()), (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__NAME, METAMODEL_ISSUE_CODE, new String[0]);
            } else {
                validator.warning(String.format("Resource at URI %s for EPackage of %s is not writable, but it already contains correct annotations.", uri.toString(), sourceClass.getName()), (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__NAME, METAMODEL_ISSUE_CODE, new String[0]);
            }
        }
    }

    private boolean checkFeatureUniquenessOnQBFAnnotations(Annotation annotation, IIssueCallback validator, Pattern pattern) {
        Collection qbfAnnotations = CorePatternLanguageHelper.getAnnotationsByName((Pattern)pattern, (String)"QueryBasedFeature");
        if (qbfAnnotations.size() > 1) {
            ValueReference feature = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"feature");
            if (feature == null) {
                validator.error("Feature must be specified when multiple QueryBasedFeature annotations are used on a single pattern.", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__NAME, ANNOTATION_ISSUE_CODE, new String[0]);
                return true;
            }
            String featureName = ((StringValue)feature).getValue();
            for (Annotation antn : qbfAnnotations) {
                String otherFeatureName;
                ValueReference otherFeature = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)antn, (String)"feature");
                if (otherFeature == null || !featureName.equals(otherFeatureName = ((StringValue)otherFeature).getValue())) continue;
                validator.error("Feature must be unique among multiple QueryBasedFeature annotations used on a single pattern.", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__NAME, ANNOTATION_ISSUE_CODE, new String[0]);
                return true;
            }
        }
        return false;
    }
}

