/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybyexample.code;

import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.addon.querybyexample.code.VariableRegister;
import org.eclipse.viatra.addon.querybyexample.interfaces.ICodeGenerator;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLAttribute;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLNegConstraint;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLPath;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLPattern;
import org.eclipse.viatra.addon.querybyexample.interfaces.beans.VQLVariableSetting;

public class CodeGeneratorImpl
implements ICodeGenerator {
    private VariableRegister variableRegister;

    public CodeGeneratorImpl(VariableRegister register) {
        this.variableRegister = register;
    }

    @Override
    public String generateConstraint(VQLConstraint eiqc) {
        return String.valueOf(eiqc.getStart().eClass().getName()) + "." + eiqc.getReference().getName() + "(" + this.variableRegister.getVariableSetting(eiqc.getStart()).getVariableName() + ", " + this.variableRegister.getVariableSetting(eiqc.getEnd()).getVariableName() + ")";
    }

    @Override
    public String generateNegConstraintFind(VQLNegConstraint eiqc) {
        String startParam = this.variableRegister.getVariableSetting(eiqc.getStart()).getVariableName();
        String endParam = this.variableRegister.getVariableSetting(eiqc.getEnd()).getVariableName();
        return "neg find " + eiqc.getHelperPatternName() + "(" + startParam + ", " + endParam + ")";
    }

    @Override
    public String generateNegConstraintHelperPattern(VQLNegConstraint eiqc) {
        String startParam = this.variableRegister.getVariableSetting(eiqc.getStart()).getVariableName();
        String endParam = this.variableRegister.getVariableSetting(eiqc.getEnd()).getVariableName();
        String startParamLine = "\t" + startParam + " : " + eiqc.getStart().eClass().getName() + ",\n";
        String endParamLine = "\t" + endParam + " : " + eiqc.getEnd().eClass().getName() + "\n";
        StringBuilder sb = new StringBuilder();
        sb.append("@QueryExplorer(checked = " + Boolean.toString(eiqc.isQueryExplorerChecked()) + ")\n");
        sb.append("pattern " + eiqc.getHelperPatternName() + "(\n");
        sb.append(startParamLine);
        sb.append(endParamLine);
        sb.append(") {\n");
        sb.append("\t" + eiqc.getStart().eClass().getName() + "." + eiqc.getReference().getName() + "(" + startParam + ", " + endParam + ");\n");
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    public String generateVariable(EObject eo) {
        VQLVariableSetting variableSetting = this.variableRegister.getVariableSetting(eo);
        String eClassName = variableSetting.getType().getName();
        String varName = variableSetting.getVariableName();
        return variableSetting.isInputVariable() ? String.valueOf(varName) + " : " + eClassName : String.valueOf(eClassName) + "(" + varName + ")";
    }

    @Override
    public String generateVariable(VQLVariableSetting variableSetting) {
        String eClassName = variableSetting.getType().getName();
        String varName = variableSetting.getVariableName();
        return variableSetting.isInputVariable() ? String.valueOf(varName) + " : " + eClassName : String.valueOf(eClassName) + "(" + varName + ")";
    }

    @Override
    public String generatePattern(VQLPattern pattern) {
        if (!pattern.validate()) {
            return "";
        }
        StringBuilder patternBuilder = new StringBuilder("package ");
        patternBuilder.append(pattern.getPackageName());
        patternBuilder.append("\n\nimport \"");
        patternBuilder.append(pattern.getNsUri());
        patternBuilder.append("\"\n\n");
        patternBuilder.append("pattern ");
        patternBuilder.append(pattern.getPatternName());
        patternBuilder.append("(\n");
        for (EObject selectedEObject : pattern.getSelectedEObjects()) {
            patternBuilder.append("\t");
            patternBuilder.append(this.generateVariable(selectedEObject));
            patternBuilder.append(",\n");
        }
        Map<EObject, VQLVariableSetting> freeVariables = this.variableRegister.getFreeVariables();
        for (VQLVariableSetting param : freeVariables.values()) {
            if (!param.isInputVariable()) continue;
            patternBuilder.append("\t");
            patternBuilder.append(this.generateVariable(param));
            patternBuilder.append(",\n");
        }
        patternBuilder.deleteCharAt(patternBuilder.length() - 1);
        patternBuilder.deleteCharAt(patternBuilder.length() - 1);
        patternBuilder.append("\n) {\n");
        for (VQLVariableSetting param : freeVariables.values()) {
            if (param.isInputVariable() || !param.isVisible()) continue;
            patternBuilder.append("\t");
            patternBuilder.append(this.generateVariable(param));
            patternBuilder.append(";\n");
        }
        for (VQLConstraint actualConstraint : pattern.getConstraints()) {
            if (!actualConstraint.isVisible()) continue;
            patternBuilder.append("\t");
            patternBuilder.append(this.generateConstraint(actualConstraint));
            patternBuilder.append(";\n");
        }
        if (pattern.getConstraints().isEmpty() && pattern.getDiscoveredEObjects().isEmpty()) {
            patternBuilder.append("\t");
            EObject eo = pattern.getSelectedEObjects().iterator().next();
            VQLVariableSetting pseudoEIQSetting = new VQLVariableSetting();
            pseudoEIQSetting.setInputVariable(false);
            pseudoEIQSetting.setVariableName(this.variableRegister.getVariableSetting(eo).getVariableName());
            pseudoEIQSetting.setType(eo.eClass());
            patternBuilder.append(this.generateVariable(pseudoEIQSetting));
            patternBuilder.append(";\n");
        }
        boolean attributeGenerated = false;
        for (VQLAttribute eiqAttribute : pattern.getAttributes()) {
            if (!eiqAttribute.isVisible()) continue;
            attributeGenerated = true;
            patternBuilder.append("\n\t");
            patternBuilder.append(this.generateAttribute(eiqAttribute));
            patternBuilder.append(";");
        }
        for (VQLAttribute eiqAttribute : pattern.getDiscoveredObjectsAttributes()) {
            if (!eiqAttribute.isVisible()) continue;
            attributeGenerated = true;
            patternBuilder.append("\n\t");
            patternBuilder.append(this.generateAttribute(eiqAttribute));
            patternBuilder.append(";");
        }
        if (attributeGenerated) {
            patternBuilder.append("\n");
        }
        if (pattern.getNegConstraints().isEmpty()) {
            patternBuilder.append("}\n");
        } else {
            patternBuilder.append("\n");
            for (VQLNegConstraint actualNegConstraint : pattern.getNegConstraints()) {
                if (!actualNegConstraint.isVisible()) continue;
                patternBuilder.append("\t");
                patternBuilder.append(this.generateNegConstraintFind(actualNegConstraint));
                patternBuilder.append(";\n");
            }
            patternBuilder.append("}\n\n");
            for (VQLNegConstraint actualNegConstraint : pattern.getNegConstraints()) {
                if (!actualNegConstraint.isVisible()) continue;
                patternBuilder.append(this.generateNegConstraintHelperPattern(actualNegConstraint));
                patternBuilder.append("\n");
            }
        }
        return patternBuilder.toString();
    }

    @Override
    public String generatePathLabel(VQLPath path) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.variableRegister.getFixVariables().get(path.getStart()).getVariableName());
        builder.append(" -> ");
        builder.append(this.variableRegister.getFixVariables().get(path.getEnd()).getVariableName());
        return builder.toString();
    }

    @Override
    public String generateAttribute(VQLAttribute attribute) {
        StringBuilder ret = new StringBuilder(attribute.getOwner().eClass().getName());
        ret.append(".");
        ret.append(attribute.getAttribute().getName());
        ret.append("(");
        ret.append(this.variableRegister.getVariableSetting(attribute.getOwner()).getVariableName());
        ret.append(", ");
        ret.append(this.generateLiteralForAttribute(attribute.getValue()));
        ret.append(")");
        return ret.toString();
    }

    @Override
    public String generateLiteralForAttribute(Object literal) {
        StringBuilder ret = new StringBuilder();
        if (literal instanceof String) {
            ret.append("\"");
            ret.append(literal.toString());
            ret.append("\"");
        } else if (literal instanceof Enumerator) {
            ret.append(literal.getClass().getSimpleName());
            ret.append("::");
            ret.append(literal.toString());
        } else if (literal instanceof Character) {
            ret.append("eval(\"");
            ret.append(literal.toString());
            ret.append("\".charAt(0))");
        } else {
            ret.append(literal.toString());
        }
        return ret.toString();
    }
}

