/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Csaba Debreceni - initial API and implementation
 *  
 */
package org.eclipse.viatra.addon.viewers.runtime.model.patterns.util;

import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2itemMatch;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.transformation.views.traceability.Trace;

/**
 * A match processor tailored for the org.eclipse.viatra.addon.viewers.runtime.model.patterns.param2item pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class Param2itemProcessor implements IMatchProcessor<Param2itemMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pParam the value of pattern parameter param in the currently processed match
   * @param pTrace the value of pattern parameter trace in the currently processed match
   * @param pItem the value of pattern parameter item in the currently processed match
   * 
   */
  public abstract void process(final Object pParam, final Trace pTrace, final Item pItem);
  
  @Override
  public void process(final Param2itemMatch match) {
    process(match.getParam(), match.getTrace(), match.getItem());
  }
}
