/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class ViatraViewerDataModel
extends ViewerDataModel {
    private ViatraQueryEngine engine;
    private Logger logger;
    private Set<IQuerySpecification<?>> patterns;

    public ViatraViewerDataModel(Collection<IQuerySpecification<?>> patterns, ViatraQueryEngine engine) throws ViatraQueryException, ViatraBaseException {
        super(engine);
        this.patterns = Sets.newHashSet(patterns);
        this.engine = engine;
        this.logger = ViatraQueryLoggingUtil.getLogger(this.getClass());
    }

    @Override
    public ViatraQueryEngine getEngine() {
        return this.engine;
    }

    public Collection<IQuerySpecification<?>> getPatterns(final String annotation) {
        return Collections2.filter(this.patterns, (Predicate)new Predicate<IQuerySpecification<?>>(){

            public boolean apply(IQuerySpecification<?> pattern) {
                return !pattern.getAnnotationsByName(annotation).isEmpty();
            }
        });
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static ViewerState newViewerState(ViatraQueryEngine engine, Collection<IQuerySpecification<?>> patterns, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        ViatraViewerDataModel m;
        try {
            m = new ViatraViewerDataModel(patterns, engine);
        }
        catch (ViatraBaseException | ViatraQueryException e) {
            Logger.getLogger(ViatraViewerDataModel.class).error((Object)e.getMessage());
            return null;
        }
        ViewerState r = ViatraViewerDataModel.newViewerState(m, filter, features);
        r.hasExternalViewerDataModel = false;
        return r;
    }

    public static ViewerState newViewerState(ViatraViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        ViewerState s = new ViewerState(model, filter, features);
        s.hasExternalViewerDataModel = true;
        return s;
    }

    @Override
    public Collection<IQuerySpecification<?>> getPatterns() {
        return this.patterns;
    }
}

