/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.specifications;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.transformation.views.traceablilty.generic.AbstractQuerySpecificationDescriptor;

public class EdgeQuerySpecificationDescriptor
extends AbstractQuerySpecificationDescriptor {
    public static final String ANNOTATION_ID = "Edge";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String LABEL = "label";
    private String source;
    private String target;
    private String label;
    private PAnnotation formatAnnotation;

    public EdgeQuerySpecificationDescriptor(IQuerySpecification<?> specification, PAnnotation annotation) throws QueryInitializationException {
        super(specification, EdgeQuerySpecificationDescriptor.getTraceSource(specification, annotation), Collections.emptyMap());
        String parameterLabelValue;
        String parameterTargetValue;
        String parameterSourceValue;
        ParameterReference parameterSource = (ParameterReference)annotation.getFirstValue(SOURCE);
        this.source = parameterSourceValue = parameterSource.getName();
        ParameterReference parameterTarget = (ParameterReference)annotation.getFirstValue(TARGET);
        this.target = parameterTargetValue = parameterTarget.getName();
        Object parameterLabel = annotation.getFirstValue(LABEL);
        this.label = parameterLabelValue = parameterLabel == null ? "" : (String)parameterLabel;
        this.formatAnnotation = specification.getFirstAnnotationByName("Format");
    }

    private static Multimap<PParameter, PParameter> getTraceSource(IQuerySpecification<?> specification, PAnnotation annotation) {
        ArrayListMultimap traces = ArrayListMultimap.create();
        ParameterReference parameterSource = (ParameterReference)annotation.getFirstValue(SOURCE);
        ParameterReference parameterTarget = (ParameterReference)annotation.getFirstValue(TARGET);
        EdgeQuerySpecificationDescriptor.insertToTraces(specification, (Multimap<PParameter, PParameter>)traces, parameterSource.getName());
        EdgeQuerySpecificationDescriptor.insertToTraces(specification, (Multimap<PParameter, PParameter>)traces, parameterTarget.getName());
        return traces;
    }

    private static void insertToTraces(IQuerySpecification<?> specification, Multimap<PParameter, PParameter> traces, String parameter) {
        String targetName = "trace<" + parameter + ">";
        PParameter var_target = new PParameter(targetName, String.valueOf(NotationPackage.eINSTANCE.getNsURI()) + "||" + NotationPackage.eINSTANCE.getItem().getName());
        int positionOfParameter = specification.getPositionOfParameter(parameter);
        PParameter var_source = (PParameter)specification.getParameters().get(positionOfParameter);
        traces.put((Object)var_target, (Object)var_source);
    }

    public boolean isFormatted() {
        return this.formatAnnotation != null;
    }

    public PAnnotation getFormatAnnotation() {
        return this.formatAnnotation;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLabel() {
        return this.label;
    }
}

