/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.tooling.ui.views;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.viatra.addon.viewers.runtime.extensions.SelectionHelper;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.viatra.addon.viewers.runtime.model.ViatraViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewersAnnotatedPatternTester;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.ViewersMultiSandboxView;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.ViewersMultiSandoxViewComponentSettings;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.tabs.IViewerSandboxTab;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;

public class ViewersMultiSandboxViewComponent
implements ISelectionProvider {
    private List<IViewerSandboxTab> tabList;
    CTabFolder folder;
    private AdvancedViatraQueryEngine engine;
    private ViewerState state;
    private ViewersMultiSandboxView host;
    private ViewersMultiSandoxViewComponentSettings settings;
    ViewersComponentConfiguration initialConfiguration;
    SelectionHelper selectionHelper = new SelectionHelper();

    public ViewersMultiSandboxViewComponent(ViewersMultiSandboxView v) {
        this.host = v;
        this.createPartControl((Composite)this.host.container);
    }

    public void initializeTabList() {
        IConfigurationElement[] providers;
        this.tabList = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = providers = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.viatra.addon.viewers.tooling.ui.viewersandboxtab");
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement provider = iConfigurationElementArray[n2];
            try {
                IViewerSandboxTab tab = (IViewerSandboxTab)provider.createExecutableExtension("implementation");
                this.tabList.add(tab);
            }
            catch (CoreException e) {
                ViewersMultiSandboxView.log("initializeTabList", (Exception)((Object)e));
            }
            ++n2;
        }
    }

    private void createSettingsTab() {
        this.settings = new ViewersMultiSandoxViewComponentSettings(this);
        this.settings.createUI();
    }

    private void createPartControl(Composite parent) {
        this.initializeTabList();
        this.folder = new CTabFolder(parent, 2176);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.folder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.createSettingsTab();
        for (IViewerSandboxTab tab : this.tabList) {
            tab.createPartControl(this.folder);
            tab.addSelectionChangedListener(this.selectionHelper.trickyListener);
        }
        this.folder.setSelection(0);
        this.folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewersMultiSandboxViewComponent.this.host.fillToolBar(ViewersMultiSandboxViewComponent.this);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewersMultiSandboxViewComponent.this.host.fillToolBar(ViewersMultiSandboxViewComponent.this);
            }
        });
        this.folder.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ViewersMultiSandboxViewComponent.this.host.setCurrentComponent(ViewersMultiSandboxViewComponent.this);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.setBackGround();
    }

    public void dispose() {
        for (IViewerSandboxTab tab : this.tabList) {
            tab.removeSelectionChangedListener(this.selectionHelper.trickyListener);
            tab.dispose();
        }
        if (this.state != null) {
            this.state.dispose();
        }
        if (this.engine != null) {
            this.engine.dispose();
        }
        if (!this.folder.isDisposed()) {
            this.folder.dispose();
        }
    }

    public void setFocus() {
        if (!this.tabList.isEmpty()) {
            this.getCurrentTabItem().getControl().setFocus();
        }
    }

    void setForeground() {
        Color bgColor = Display.getCurrent().getSystemColor(20);
        this.folder.setBackground(bgColor);
        this.getCurrentTabItem().getControl().setBackground(bgColor);
    }

    void setBackGround() {
        Color bgColor = Display.getCurrent().getSystemColor(19);
        this.folder.setBackground(bgColor);
        this.getCurrentTabItem().getControl().setBackground(bgColor);
    }

    private IViewSite getViewSite() {
        return this.host.getViewSite();
    }

    private IViewerSandboxTab getCurrentContributedTab() {
        if (this.folder.getSelectionIndex() <= 0) {
            return null;
        }
        return this.tabList.get(this.folder.getSelectionIndex() - 1);
    }

    private CTabItem getCurrentTabItem() {
        return this.folder.getSelection();
    }

    void fillToolBarBasedOnCurrentTab() {
        IViewerSandboxTab tab = this.getCurrentContributedTab();
        if (tab != null) {
            IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
            for (IContributionItem item : this.getToolbarContributions(tab)) {
                if (item instanceof MenuManager) {
                    IContributionItem[] iContributionItemArray = ((MenuManager)item).getItems();
                    int n = iContributionItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem _item = iContributionItemArray[n2];
                        mgr.add(_item);
                        ++n2;
                    }
                    continue;
                }
                mgr.add(item);
            }
            mgr.update(true);
            IMenuManager mmgr = this.getViewSite().getActionBars().getMenuManager();
            mmgr.removeAll();
            for (IContributionItem item : this.getDropdownMenuContributions(tab)) {
                mmgr.add(item);
            }
            mmgr.updateAll(true);
        }
    }

    private List<IContributionItem> getDropdownMenuContributions(IViewerSandboxTab tab) {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        if (tab != null && tab.getDropDownMenuContributions() != null) {
            r.addAll(tab.getDropDownMenuContributions());
        }
        return r;
    }

    private List<IContributionItem> getToolbarContributions(IViewerSandboxTab tab) {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        if (tab != null && tab.getToolBarContributions() != null) {
            r.addAll(tab.getToolBarContributions());
        }
        return r;
    }

    void applyConfiguration(ViewersComponentConfiguration c) {
        try {
            this.doSetContents(c.getScope(), c.getPatterns(), c.getFilter());
        }
        catch (ViatraQueryException e) {
            ViewersMultiSandboxView.log("applyConfiguration", (Exception)((Object)e));
        }
    }

    public void initializeContents(ViewersComponentConfiguration c) throws ViatraQueryException {
        if (c != null) {
            this.initializeContents(c.getScope(), c.getPatterns(), c.getFilter());
        }
    }

    public void initializeContents(EMFScope model, Collection<IQuerySpecification<?>> _patterns, ViewerDataFilter filter) throws ViatraQueryException {
        if (model != null) {
            Collection<IQuerySpecification<?>> patterns = ViewersMultiSandboxViewComponent.getPatternsWithProperAnnotations(_patterns);
            this.initialConfiguration = new ViewersComponentConfiguration(model, patterns, filter);
            this.doSetContents(model, patterns, filter);
            this.settings.initialConfigurationChanged(this.initialConfiguration);
        }
    }

    private void doSetContents(EMFScope scope, Collection<IQuerySpecification<?>> patterns, ViewerDataFilter filter) throws ViatraQueryException {
        if (this.state != null) {
            this.state.dispose();
        }
        this.state = ViatraViewerDataModel.newViewerState((ViatraQueryEngine)this.getEngine(scope), ViewersMultiSandboxViewComponent.getPatternsWithProperAnnotations(patterns), (ViewerDataFilter)filter, (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.EDGE, (Object)ViewerState.ViewerStateFeature.CONTAINMENT));
        for (IViewerSandboxTab tab : this.tabList) {
            tab.bindState(this.state);
        }
    }

    private AdvancedViatraQueryEngine getEngine(EMFScope scope) throws ViatraQueryException {
        if (this.engine != null) {
            this.engine.dispose();
        }
        boolean wildcardMode = ViatraQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra.query.tooling.ui.queryexplorer.WildcardMode");
        boolean dynamicEMFMode = ViatraQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra.query.tooling.ui.queryexplorer.DynamicEMFMode");
        this.engine = AdvancedViatraQueryEngine.createUnmanagedEngine((QueryScope)new EMFScope(scope.getScopeRoots(), new BaseIndexOptions().withDynamicEMFMode(dynamicEMFMode).withWildcardMode(wildcardMode)));
        ViewersMultiSandboxView.log("Viewers initialized a new VIATRA Query engine with wildcardMode: " + wildcardMode + ", dynamicMode: " + dynamicEMFMode);
        return this.engine;
    }

    private static Collection<IQuerySpecification<?>> getPatternsWithProperAnnotations(Collection<IQuerySpecification<?>> input) {
        ArrayList res = Lists.newArrayList();
        for (IQuerySpecification<?> p : input) {
            if (!Iterables.any((Iterable)p.getAllAnnotations(), (Predicate)new ViewersAnnotatedPatternTester())) continue;
            res.add(p);
        }
        return res;
    }

    public void setSelection(ISelection selection) {
        for (IViewerSandboxTab tab : this.tabList) {
            tab.setSelection(this.selectionHelper.unwrapElements_EObjectsToViewersElements(selection, this.state));
        }
    }

    public ISelection getSelection() {
        IViewerSandboxTab tab = this.getCurrentContributedTab();
        if (tab != null) {
            return this.selectionHelper.unwrapElements_ViewersElementsToEObjects(this.getCurrentContributedTab().getSelection());
        }
        return StructuredSelection.EMPTY;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHelper.selectionChangedListeners.add(listener);
        for (IViewerSandboxTab tab : this.tabList) {
            tab.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHelper.selectionChangedListeners.remove(listener);
        for (IViewerSandboxTab tab : this.tabList) {
            tab.removeSelectionChangedListener(listener);
        }
    }
}

