/**
 */
package org.eclipse.viatra.cep.core.metamodels.automaton.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.AutomatonPackage;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.FinalState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;
import org.eclipse.viatra.cep.core.metamodels.automaton.TrapState;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Automaton</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.cep.core.metamodels.automaton.impl.AutomatonImpl#getStates <em>States</em>}</li>
 *   <li>{@link org.eclipse.viatra.cep.core.metamodels.automaton.impl.AutomatonImpl#getEventPatternId <em>Event Pattern Id</em>}</li>
 *   <li>{@link org.eclipse.viatra.cep.core.metamodels.automaton.impl.AutomatonImpl#getEventTokens <em>Event Tokens</em>}</li>
 *   <li>{@link org.eclipse.viatra.cep.core.metamodels.automaton.impl.AutomatonImpl#getTimedZones <em>Timed Zones</em>}</li>
 *   <li>{@link org.eclipse.viatra.cep.core.metamodels.automaton.impl.AutomatonImpl#getInitialState <em>Initial State</em>}</li>
 *   <li>{@link org.eclipse.viatra.cep.core.metamodels.automaton.impl.AutomatonImpl#getFinalStates <em>Final States</em>}</li>
 *   <li>{@link org.eclipse.viatra.cep.core.metamodels.automaton.impl.AutomatonImpl#getTrapState <em>Trap State</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AutomatonImpl extends MinimalEObjectImpl.Container implements Automaton {
	/**
	 * The cached value of the '{@link #getStates() <em>States</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStates()
	 * @generated
	 * @ordered
	 */
	protected EList<State> states;

	/**
	 * The default value of the '{@link #getEventPatternId() <em>Event Pattern Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventPatternId()
	 * @generated
	 * @ordered
	 */
	protected static final String EVENT_PATTERN_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEventPatternId() <em>Event Pattern Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventPatternId()
	 * @generated
	 * @ordered
	 */
	protected String eventPatternId = EVENT_PATTERN_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEventTokens() <em>Event Tokens</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventTokens()
	 * @generated
	 * @ordered
	 */
	protected EList<EventToken> eventTokens;

	/**
	 * The cached value of the '{@link #getTimedZones() <em>Timed Zones</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimedZones()
	 * @generated
	 * @ordered
	 */
	protected EList<TimedZone> timedZones;

	/**
	 * The cached setting delegate for the '{@link #getInitialState() <em>Initial State</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitialState()
	 * @generated
	 * @ordered
	 */
	protected EStructuralFeature.Internal.SettingDelegate INITIAL_STATE__ESETTING_DELEGATE = ((EStructuralFeature.Internal)AutomatonPackage.Literals.AUTOMATON__INITIAL_STATE).getSettingDelegate();

	/**
	 * The cached setting delegate for the '{@link #getFinalStates() <em>Final States</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFinalStates()
	 * @generated
	 * @ordered
	 */
	protected EStructuralFeature.Internal.SettingDelegate FINAL_STATES__ESETTING_DELEGATE = ((EStructuralFeature.Internal)AutomatonPackage.Literals.AUTOMATON__FINAL_STATES).getSettingDelegate();

	/**
	 * The cached setting delegate for the '{@link #getTrapState() <em>Trap State</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTrapState()
	 * @generated
	 * @ordered
	 */
	protected EStructuralFeature.Internal.SettingDelegate TRAP_STATE__ESETTING_DELEGATE = ((EStructuralFeature.Internal)AutomatonPackage.Literals.AUTOMATON__TRAP_STATE).getSettingDelegate();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AutomatonImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AutomatonPackage.Literals.AUTOMATON;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<State> getStates() {
		if (states == null) {
			states = new EObjectContainmentEList<State>(State.class, this, AutomatonPackage.AUTOMATON__STATES);
		}
		return states;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEventPatternId() {
		return eventPatternId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEventPatternId(String newEventPatternId) {
		String oldEventPatternId = eventPatternId;
		eventPatternId = newEventPatternId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AutomatonPackage.AUTOMATON__EVENT_PATTERN_ID, oldEventPatternId, eventPatternId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EventToken> getEventTokens() {
		if (eventTokens == null) {
			eventTokens = new EObjectContainmentEList<EventToken>(EventToken.class, this, AutomatonPackage.AUTOMATON__EVENT_TOKENS);
		}
		return eventTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TimedZone> getTimedZones() {
		if (timedZones == null) {
			timedZones = new EObjectContainmentEList<TimedZone>(TimedZone.class, this, AutomatonPackage.AUTOMATON__TIMED_ZONES);
		}
		return timedZones;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InitState getInitialState() {
		return (InitState)INITIAL_STATE__ESETTING_DELEGATE.dynamicGet(this, null, 0, true, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InitState basicGetInitialState() {
		return (InitState)INITIAL_STATE__ESETTING_DELEGATE.dynamicGet(this, null, 0, false, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<FinalState> getFinalStates() {
		return (EList<FinalState>)FINAL_STATES__ESETTING_DELEGATE.dynamicGet(this, null, 0, true, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TrapState getTrapState() {
		return (TrapState)TRAP_STATE__ESETTING_DELEGATE.dynamicGet(this, null, 0, true, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TrapState basicGetTrapState() {
		return (TrapState)TRAP_STATE__ESETTING_DELEGATE.dynamicGet(this, null, 0, false, false);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case AutomatonPackage.AUTOMATON__STATES:
				return ((InternalEList<?>)getStates()).basicRemove(otherEnd, msgs);
			case AutomatonPackage.AUTOMATON__EVENT_TOKENS:
				return ((InternalEList<?>)getEventTokens()).basicRemove(otherEnd, msgs);
			case AutomatonPackage.AUTOMATON__TIMED_ZONES:
				return ((InternalEList<?>)getTimedZones()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AutomatonPackage.AUTOMATON__STATES:
				return getStates();
			case AutomatonPackage.AUTOMATON__EVENT_PATTERN_ID:
				return getEventPatternId();
			case AutomatonPackage.AUTOMATON__EVENT_TOKENS:
				return getEventTokens();
			case AutomatonPackage.AUTOMATON__TIMED_ZONES:
				return getTimedZones();
			case AutomatonPackage.AUTOMATON__INITIAL_STATE:
				if (resolve) return getInitialState();
				return basicGetInitialState();
			case AutomatonPackage.AUTOMATON__FINAL_STATES:
				return getFinalStates();
			case AutomatonPackage.AUTOMATON__TRAP_STATE:
				if (resolve) return getTrapState();
				return basicGetTrapState();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AutomatonPackage.AUTOMATON__STATES:
				getStates().clear();
				getStates().addAll((Collection<? extends State>)newValue);
				return;
			case AutomatonPackage.AUTOMATON__EVENT_PATTERN_ID:
				setEventPatternId((String)newValue);
				return;
			case AutomatonPackage.AUTOMATON__EVENT_TOKENS:
				getEventTokens().clear();
				getEventTokens().addAll((Collection<? extends EventToken>)newValue);
				return;
			case AutomatonPackage.AUTOMATON__TIMED_ZONES:
				getTimedZones().clear();
				getTimedZones().addAll((Collection<? extends TimedZone>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AutomatonPackage.AUTOMATON__STATES:
				getStates().clear();
				return;
			case AutomatonPackage.AUTOMATON__EVENT_PATTERN_ID:
				setEventPatternId(EVENT_PATTERN_ID_EDEFAULT);
				return;
			case AutomatonPackage.AUTOMATON__EVENT_TOKENS:
				getEventTokens().clear();
				return;
			case AutomatonPackage.AUTOMATON__TIMED_ZONES:
				getTimedZones().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AutomatonPackage.AUTOMATON__STATES:
				return states != null && !states.isEmpty();
			case AutomatonPackage.AUTOMATON__EVENT_PATTERN_ID:
				return EVENT_PATTERN_ID_EDEFAULT == null ? eventPatternId != null : !EVENT_PATTERN_ID_EDEFAULT.equals(eventPatternId);
			case AutomatonPackage.AUTOMATON__EVENT_TOKENS:
				return eventTokens != null && !eventTokens.isEmpty();
			case AutomatonPackage.AUTOMATON__TIMED_ZONES:
				return timedZones != null && !timedZones.isEmpty();
			case AutomatonPackage.AUTOMATON__INITIAL_STATE:
				return INITIAL_STATE__ESETTING_DELEGATE.dynamicIsSet(this, null, 0);
			case AutomatonPackage.AUTOMATON__FINAL_STATES:
				return FINAL_STATES__ESETTING_DELEGATE.dynamicIsSet(this, null, 0);
			case AutomatonPackage.AUTOMATON__TRAP_STATE:
				return TRAP_STATE__ESETTING_DELEGATE.dynamicIsSet(this, null, 0);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (eventPatternId: ");
		result.append(eventPatternId);
		result.append(')');
		return result.toString();
	}

} //AutomatonImpl
