/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.metamodels.derived;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.derived.InitialStateMatch;
import org.eclipse.viatra.cep.core.metamodels.derived.util.InitialStateQuerySpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.metamodels.derived.initialState pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link InitialStateMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * {@literal @}QueryBasedFeature
 * pattern initialState(this : Automaton, initState : InitState){
 * 	Automaton.states(this, initState);
 * }
 * </pre></code>
 * 
 * @see InitialStateMatch
 * @see InitialStateProcessor
 * @see InitialStateQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class InitialStateMatcher extends BaseMatcher<InitialStateMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static InitialStateMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    InitialStateMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (InitialStateMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static InitialStateMatcher create() throws ViatraQueryException {
    return new InitialStateMatcher();
  }
  
  private final static int POSITION_THIS = 0;
  
  private final static int POSITION_INITSTATE = 1;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(InitialStateMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private InitialStateMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pThis the fixed value of pattern parameter this, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @return matches represented as a InitialStateMatch object.
   * 
   */
  public Collection<InitialStateMatch> getAllMatches(final Automaton pThis, final InitState pInitState) {
    return rawGetAllMatches(new Object[]{pThis, pInitState});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pThis the fixed value of pattern parameter this, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @return a match represented as a InitialStateMatch object, or null if no match is found.
   * 
   */
  public InitialStateMatch getOneArbitraryMatch(final Automaton pThis, final InitState pInitState) {
    return rawGetOneArbitraryMatch(new Object[]{pThis, pInitState});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pThis the fixed value of pattern parameter this, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Automaton pThis, final InitState pInitState) {
    return rawHasMatch(new Object[]{pThis, pInitState});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pThis the fixed value of pattern parameter this, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Automaton pThis, final InitState pInitState) {
    return rawCountMatches(new Object[]{pThis, pInitState});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pThis the fixed value of pattern parameter this, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Automaton pThis, final InitState pInitState, final IMatchProcessor<? super InitialStateMatch> processor) {
    rawForEachMatch(new Object[]{pThis, pInitState}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pThis the fixed value of pattern parameter this, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Automaton pThis, final InitState pInitState, final IMatchProcessor<? super InitialStateMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pThis, pInitState}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pThis the fixed value of pattern parameter this, or null if not bound.
   * @param pInitState the fixed value of pattern parameter initState, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public InitialStateMatch newMatch(final Automaton pThis, final InitState pInitState) {
    return InitialStateMatch.newMatch(pThis, pInitState);
  }
  
  /**
   * Retrieve the set of values that occur in matches for this.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Automaton> rawAccumulateAllValuesOfthis(final Object[] parameters) {
    Set<Automaton> results = new HashSet<Automaton>();
    rawAccumulateAllValues(POSITION_THIS, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for this.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfthis() {
    return rawAccumulateAllValuesOfthis(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for this.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfthis(final InitialStateMatch partialMatch) {
    return rawAccumulateAllValuesOfthis(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for this.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfthis(final InitState pInitState) {
    return rawAccumulateAllValuesOfthis(new Object[]{
    null, 
    pInitState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for initState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<InitState> rawAccumulateAllValuesOfinitState(final Object[] parameters) {
    Set<InitState> results = new HashSet<InitState>();
    rawAccumulateAllValues(POSITION_INITSTATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for initState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<InitState> getAllValuesOfinitState() {
    return rawAccumulateAllValuesOfinitState(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for initState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<InitState> getAllValuesOfinitState(final InitialStateMatch partialMatch) {
    return rawAccumulateAllValuesOfinitState(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for initState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<InitState> getAllValuesOfinitState(final Automaton pThis) {
    return rawAccumulateAllValuesOfinitState(new Object[]{
    pThis, 
    null
    });
  }
  
  @Override
  protected InitialStateMatch tupleToMatch(final Tuple t) {
    try {
    	return InitialStateMatch.newMatch((Automaton) t.get(POSITION_THIS), (InitState) t.get(POSITION_INITSTATE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected InitialStateMatch arrayToMatch(final Object[] match) {
    try {
    	return InitialStateMatch.newMatch((Automaton) match[POSITION_THIS], (InitState) match[POSITION_INITSTATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected InitialStateMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return InitialStateMatch.newMutableMatch((Automaton) match[POSITION_THIS], (InitState) match[POSITION_INITSTATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<InitialStateMatcher> querySpecification() throws ViatraQueryException {
    return InitialStateQuerySpecification.instance();
  }
}
