/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.metamodels.derived.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.metamodels.derived.InitialStateMatch;
import org.eclipse.viatra.cep.core.metamodels.derived.InitialStateMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate InitialStateMatcher in a type-safe way.
 * 
 * @see InitialStateMatcher
 * @see InitialStateMatch
 * 
 */
@SuppressWarnings("all")
public final class InitialStateQuerySpecification extends BaseGeneratedEMFQuerySpecification<InitialStateMatcher> {
  private InitialStateQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static InitialStateQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected InitialStateMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return InitialStateMatcher.on(engine);
  }
  
  @Override
  public InitialStateMatcher instantiate() throws ViatraQueryException {
    return InitialStateMatcher.create();
  }
  
  @Override
  public InitialStateMatch newEmptyMatch() {
    return InitialStateMatch.newEmptyMatch();
  }
  
  @Override
  public InitialStateMatch newMatch(final Object... parameters) {
    return InitialStateMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.InitState) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link InitialStateQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link InitialStateQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static InitialStateQuerySpecification INSTANCE = new InitialStateQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static InitialStateQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pThis = new PParameter("this", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "Automaton")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pInitState = new PParameter("initState", "org.eclipse.viatra.cep.core.metamodels.automaton.InitState", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "InitState")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pThis, parameter_pInitState);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.metamodels.derived.initialState";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("this","initState");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_this = body.getOrCreateVariableByName("this");
      		PVariable var_initState = body.getOrCreateVariableByName("initState");
      		new TypeConstraint(body, new FlatTuple(var_this), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_initState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "InitState")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_this, parameter_pThis),
      		   new ExportedParameter(body, var_initState, parameter_pInitState)
      		));
      		// 	Automaton.states(this, initState)
      		new TypeConstraint(body, new FlatTuple(var_this), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_this, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_0_, var_initState);
      		bodies.add(body);
      	}
      	{
      		PAnnotation annotation = new PAnnotation("QueryBasedFeature");
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
