/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.metamodels.derived.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.metamodels.derived.FinalStatesMatch;
import org.eclipse.viatra.cep.core.metamodels.derived.FinalStatesMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate FinalStatesMatcher in a type-safe way.
 * 
 * @see FinalStatesMatcher
 * @see FinalStatesMatch
 * 
 */
@SuppressWarnings("all")
public final class FinalStatesQuerySpecification extends BaseGeneratedEMFQuerySpecification<FinalStatesMatcher> {
  private FinalStatesQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static FinalStatesQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected FinalStatesMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return FinalStatesMatcher.on(engine);
  }
  
  @Override
  public FinalStatesMatcher instantiate() throws ViatraQueryException {
    return FinalStatesMatcher.create();
  }
  
  @Override
  public FinalStatesMatch newEmptyMatch() {
    return FinalStatesMatch.newEmptyMatch();
  }
  
  @Override
  public FinalStatesMatch newMatch(final Object... parameters) {
    return FinalStatesMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.FinalState) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link FinalStatesQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link FinalStatesQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static FinalStatesQuerySpecification INSTANCE = new FinalStatesQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static FinalStatesQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pThis = new PParameter("this", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "Automaton")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pFinalState = new PParameter("finalState", "org.eclipse.viatra.cep.core.metamodels.automaton.FinalState", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "FinalState")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pThis, parameter_pFinalState);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.metamodels.derived.finalStates";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("this","finalState");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_this = body.getOrCreateVariableByName("this");
      		PVariable var_finalState = body.getOrCreateVariableByName("finalState");
      		new TypeConstraint(body, new FlatTuple(var_this), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_finalState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "FinalState")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_this, parameter_pThis),
      		   new ExportedParameter(body, var_finalState, parameter_pFinalState)
      		));
      		// 	Automaton.states(this, finalState)
      		new TypeConstraint(body, new FlatTuple(var_this), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_this, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_0_, var_finalState);
      		bodies.add(body);
      	}
      	{
      		PAnnotation annotation = new PAnnotation("QueryBasedFeature");
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
