/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.api.engine;

import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatch;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatcher;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.SimpleModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformation;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformationStatements;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@SuppressWarnings("all")
public class ResetTransformations {
  @Extension
  private BatchTransformationRuleFactory ruleFactory = new BatchTransformationRuleFactory();
  
  @Extension
  private BatchTransformation transformation;
  
  @Extension
  private BatchTransformationStatements statements;
  
  @Extension
  private IModelManipulations manipulation;
  
  public ResetTransformations(final InternalModel internalModel) {
    try {
      EMFScope _eMFScope = new EMFScope(internalModel);
      BatchTransformation.BatchTransformationBuilder _forScope = BatchTransformation.forScope(_eMFScope);
      BatchTransformation _build = _forScope.build();
      this.transformation = _build;
      BatchTransformationStatements _transformationStatements = this.transformation.getTransformationStatements();
      this.statements = _transformationStatements;
      ViatraQueryEngine _queryEngine = this.transformation.getQueryEngine();
      SimpleModelManipulations _simpleModelManipulations = new SimpleModelManipulations(_queryEngine);
      this.manipulation = _simpleModelManipulations;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void resetAll() {
    this.statements.<ResettableEventTokenMatch>fireWhilePossible(this.deleteTokensDuringReset);
  }
  
  private final BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher> deleteTokensDuringReset = new Function0<BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher>>() {
    public BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ResettableEventTokenMatch, ResettableEventTokenMatcher> _createRule = ResetTransformations.this.ruleFactory.<ResettableEventTokenMatch, ResettableEventTokenMatcher>createRule();
        IQuerySpecification<ResettableEventTokenMatcher> _querySpecification = ResettableEventTokenMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ResettableEventTokenMatch, ResettableEventTokenMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<ResettableEventTokenMatch> _function = new IMatchProcessor<ResettableEventTokenMatch>() {
          @Override
          public void process(final ResettableEventTokenMatch it) {
            Automaton _automaton = it.getAutomaton();
            EList<EventToken> _eventTokens = _automaton.getEventTokens();
            EventToken _eventToken = it.getEventToken();
            _eventTokens.remove(_eventToken);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ResettableEventTokenMatch, ResettableEventTokenMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
}
