/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.compiler.AndPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.AndPatternQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.andPattern pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link AndPatternMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern andPattern(eventPattern : ComplexEventPattern) {
 * 	find complexPattern(eventPattern, operator);
 * 	AND(operator);
 * }
 * </pre></code>
 * 
 * @see AndPatternMatch
 * @see AndPatternProcessor
 * @see AndPatternQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class AndPatternMatcher extends BaseMatcher<AndPatternMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static AndPatternMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    AndPatternMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (AndPatternMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static AndPatternMatcher create() throws ViatraQueryException {
    return new AndPatternMatcher();
  }
  
  private final static int POSITION_EVENTPATTERN = 0;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(AndPatternMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private AndPatternMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return matches represented as a AndPatternMatch object.
   * 
   */
  public Collection<AndPatternMatch> getAllMatches(final ComplexEventPattern pEventPattern) {
    return rawGetAllMatches(new Object[]{pEventPattern});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return a match represented as a AndPatternMatch object, or null if no match is found.
   * 
   */
  public AndPatternMatch getOneArbitraryMatch(final ComplexEventPattern pEventPattern) {
    return rawGetOneArbitraryMatch(new Object[]{pEventPattern});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final ComplexEventPattern pEventPattern) {
    return rawHasMatch(new Object[]{pEventPattern});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final ComplexEventPattern pEventPattern) {
    return rawCountMatches(new Object[]{pEventPattern});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final ComplexEventPattern pEventPattern, final IMatchProcessor<? super AndPatternMatch> processor) {
    rawForEachMatch(new Object[]{pEventPattern}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final ComplexEventPattern pEventPattern, final IMatchProcessor<? super AndPatternMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pEventPattern}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public AndPatternMatch newMatch(final ComplexEventPattern pEventPattern) {
    return AndPatternMatch.newMatch(pEventPattern);
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<ComplexEventPattern> rawAccumulateAllValuesOfeventPattern(final Object[] parameters) {
    Set<ComplexEventPattern> results = new HashSet<ComplexEventPattern>();
    rawAccumulateAllValues(POSITION_EVENTPATTERN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ComplexEventPattern> getAllValuesOfeventPattern() {
    return rawAccumulateAllValuesOfeventPattern(emptyArray());
  }
  
  @Override
  protected AndPatternMatch tupleToMatch(final Tuple t) {
    try {
    	return AndPatternMatch.newMatch((ComplexEventPattern) t.get(POSITION_EVENTPATTERN));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected AndPatternMatch arrayToMatch(final Object[] match) {
    try {
    	return AndPatternMatch.newMatch((ComplexEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected AndPatternMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return AndPatternMatch.newMutableMatch((ComplexEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<AndPatternMatcher> querySpecification() throws ViatraQueryException {
    return AndPatternQuerySpecification.instance();
  }
}
