/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentStatesQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.equivalentStates pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link EquivalentStatesMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern
 * equivalentStates(transition1 : TypedTransition, transition2 : TypedTransition, preState : State, postState1 : State, postState2 : State) {
 * 	transition1 != transition2;
 * 	
 * 	find sameBooleanTransitionType(transition1, transition2);
 * 
 * 	Transition.preState(transition1, preState);
 * 	Transition.preState(transition2, preState);
 * 
 * 	Transition.postState(transition1, postState1);
 * 	Transition.postState(transition2, postState2);
 * 
 * 	postState1 != postState2;
 * 
 * 	TypedTransition.guards(transition1, guard1);
 * 	TypedTransition.guards(transition2, guard2);
 * 
 * 	Guard.eventType(guard1, et1);
 * 	Guard.eventType(guard2, et2);
 * 
 * 	et1 == et2;
 * 
 * 	Automaton.states(automaton, preState);
 * 	Automaton.states(automaton, postState1);
 * 	Automaton.states(automaton, postState2);
 * }
 * </pre></code>
 * 
 * @see EquivalentStatesMatch
 * @see EquivalentStatesProcessor
 * @see EquivalentStatesQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class EquivalentStatesMatcher extends BaseMatcher<EquivalentStatesMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EquivalentStatesMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    EquivalentStatesMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (EquivalentStatesMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EquivalentStatesMatcher create() throws ViatraQueryException {
    return new EquivalentStatesMatcher();
  }
  
  private final static int POSITION_TRANSITION1 = 0;
  
  private final static int POSITION_TRANSITION2 = 1;
  
  private final static int POSITION_PRESTATE = 2;
  
  private final static int POSITION_POSTSTATE1 = 3;
  
  private final static int POSITION_POSTSTATE2 = 4;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(EquivalentStatesMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private EquivalentStatesMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @return matches represented as a EquivalentStatesMatch object.
   * 
   */
  public Collection<EquivalentStatesMatch> getAllMatches(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return rawGetAllMatches(new Object[]{pTransition1, pTransition2, pPreState, pPostState1, pPostState2});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @return a match represented as a EquivalentStatesMatch object, or null if no match is found.
   * 
   */
  public EquivalentStatesMatch getOneArbitraryMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return rawGetOneArbitraryMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState1, pPostState2});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return rawHasMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState1, pPostState2});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return rawCountMatches(new Object[]{pTransition1, pTransition2, pPreState, pPostState1, pPostState2});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2, final IMatchProcessor<? super EquivalentStatesMatch> processor) {
    rawForEachMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState1, pPostState2}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2, final IMatchProcessor<? super EquivalentStatesMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pTransition1, pTransition2, pPreState, pPostState1, pPostState2}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public EquivalentStatesMatch newMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return EquivalentStatesMatch.newMatch(pTransition1, pTransition2, pPreState, pPostState1, pPostState2);
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TypedTransition> rawAccumulateAllValuesOftransition1(final Object[] parameters) {
    Set<TypedTransition> results = new HashSet<TypedTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION1, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition1() {
    return rawAccumulateAllValuesOftransition1(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition1(final EquivalentStatesMatch partialMatch) {
    return rawAccumulateAllValuesOftransition1(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition1(final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return rawAccumulateAllValuesOftransition1(new Object[]{
    null, 
    pTransition2, 
    pPreState, 
    pPostState1, 
    pPostState2
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TypedTransition> rawAccumulateAllValuesOftransition2(final Object[] parameters) {
    Set<TypedTransition> results = new HashSet<TypedTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION2, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition2() {
    return rawAccumulateAllValuesOftransition2(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition2(final EquivalentStatesMatch partialMatch) {
    return rawAccumulateAllValuesOftransition2(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition2(final TypedTransition pTransition1, final State pPreState, final State pPostState1, final State pPostState2) {
    return rawAccumulateAllValuesOftransition2(new Object[]{
    pTransition1, 
    null, 
    pPreState, 
    pPostState1, 
    pPostState2
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfpreState(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_PRESTATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState() {
    return rawAccumulateAllValuesOfpreState(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState(final EquivalentStatesMatch partialMatch) {
    return rawAccumulateAllValuesOfpreState(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPostState1, final State pPostState2) {
    return rawAccumulateAllValuesOfpreState(new Object[]{
    pTransition1, 
    pTransition2, 
    null, 
    pPostState1, 
    pPostState2
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfpostState1(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_POSTSTATE1, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState1() {
    return rawAccumulateAllValuesOfpostState1(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState1(final EquivalentStatesMatch partialMatch) {
    return rawAccumulateAllValuesOfpostState1(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState1(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState2) {
    return rawAccumulateAllValuesOfpostState1(new Object[]{
    pTransition1, 
    pTransition2, 
    pPreState, 
    null, 
    pPostState2
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfpostState2(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_POSTSTATE2, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState2() {
    return rawAccumulateAllValuesOfpostState2(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState2(final EquivalentStatesMatch partialMatch) {
    return rawAccumulateAllValuesOfpostState2(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState2.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState2(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1) {
    return rawAccumulateAllValuesOfpostState2(new Object[]{
    pTransition1, 
    pTransition2, 
    pPreState, 
    pPostState1, 
    null
    });
  }
  
  @Override
  protected EquivalentStatesMatch tupleToMatch(final Tuple t) {
    try {
    	return EquivalentStatesMatch.newMatch((TypedTransition) t.get(POSITION_TRANSITION1), (TypedTransition) t.get(POSITION_TRANSITION2), (State) t.get(POSITION_PRESTATE), (State) t.get(POSITION_POSTSTATE1), (State) t.get(POSITION_POSTSTATE2));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EquivalentStatesMatch arrayToMatch(final Object[] match) {
    try {
    	return EquivalentStatesMatch.newMatch((TypedTransition) match[POSITION_TRANSITION1], (TypedTransition) match[POSITION_TRANSITION2], (State) match[POSITION_PRESTATE], (State) match[POSITION_POSTSTATE1], (State) match[POSITION_POSTSTATE2]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EquivalentStatesMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return EquivalentStatesMatch.newMutableMatch((TypedTransition) match[POSITION_TRANSITION1], (TypedTransition) match[POSITION_TRANSITION2], (State) match[POSITION_PRESTATE], (State) match[POSITION_POSTSTATE1], (State) match[POSITION_POSTSTATE2]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<EquivalentStatesMatcher> querySpecification() throws ViatraQueryException {
    return EquivalentStatesQuerySpecification.instance();
  }
}
