/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.compiler.NegativeTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.negativeTransition pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link NegativeTransitionMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern negativeTransition(transition : TypedTransition) {
 * 	NegativeTransition(transition);
 * }
 * </pre></code>
 * 
 * @see NegativeTransitionMatch
 * @see NegativeTransitionProcessor
 * @see NegativeTransitionQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class NegativeTransitionMatcher extends BaseMatcher<NegativeTransitionMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static NegativeTransitionMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    NegativeTransitionMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (NegativeTransitionMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static NegativeTransitionMatcher create() throws ViatraQueryException {
    return new NegativeTransitionMatcher();
  }
  
  private final static int POSITION_TRANSITION = 0;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(NegativeTransitionMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private NegativeTransitionMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @return matches represented as a NegativeTransitionMatch object.
   * 
   */
  public Collection<NegativeTransitionMatch> getAllMatches(final TypedTransition pTransition) {
    return rawGetAllMatches(new Object[]{pTransition});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @return a match represented as a NegativeTransitionMatch object, or null if no match is found.
   * 
   */
  public NegativeTransitionMatch getOneArbitraryMatch(final TypedTransition pTransition) {
    return rawGetOneArbitraryMatch(new Object[]{pTransition});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final TypedTransition pTransition) {
    return rawHasMatch(new Object[]{pTransition});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final TypedTransition pTransition) {
    return rawCountMatches(new Object[]{pTransition});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final TypedTransition pTransition, final IMatchProcessor<? super NegativeTransitionMatch> processor) {
    rawForEachMatch(new Object[]{pTransition}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final TypedTransition pTransition, final IMatchProcessor<? super NegativeTransitionMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pTransition}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public NegativeTransitionMatch newMatch(final TypedTransition pTransition) {
    return NegativeTransitionMatch.newMatch(pTransition);
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TypedTransition> rawAccumulateAllValuesOftransition(final Object[] parameters) {
    Set<TypedTransition> results = new HashSet<TypedTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition() {
    return rawAccumulateAllValuesOftransition(emptyArray());
  }
  
  @Override
  protected NegativeTransitionMatch tupleToMatch(final Tuple t) {
    try {
    	return NegativeTransitionMatch.newMatch((TypedTransition) t.get(POSITION_TRANSITION));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NegativeTransitionMatch arrayToMatch(final Object[] match) {
    try {
    	return NegativeTransitionMatch.newMatch((TypedTransition) match[POSITION_TRANSITION]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NegativeTransitionMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return NegativeTransitionMatch.newMutableMatch((TypedTransition) match[POSITION_TRANSITION]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<NegativeTransitionMatcher> querySpecification() throws ViatraQueryException {
    return NegativeTransitionQuerySpecification.instance();
  }
}
