/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.compiler.util.NotPatternQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.compiler.notPattern pattern,
 * to be used in conjunction with {@link NotPatternMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see NotPatternMatcher
 * @see NotPatternProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class NotPatternMatch extends BasePatternMatch {
  private ComplexEventPattern fEventPattern;
  
  private static List<String> parameterNames = makeImmutableList("eventPattern");
  
  private NotPatternMatch(final ComplexEventPattern pEventPattern) {
    this.fEventPattern = pEventPattern;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("eventPattern".equals(parameterName)) return this.fEventPattern;
    return null;
  }
  
  public ComplexEventPattern getEventPattern() {
    return this.fEventPattern;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("eventPattern".equals(parameterName) ) {
    	this.fEventPattern = (ComplexEventPattern) newValue;
    	return true;
    }
    return false;
  }
  
  public void setEventPattern(final ComplexEventPattern pEventPattern) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventPattern = pEventPattern;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.compiler.notPattern";
  }
  
  @Override
  public List<String> parameterNames() {
    return NotPatternMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fEventPattern};
  }
  
  @Override
  public NotPatternMatch toImmutable() {
    return isMutable() ? newMatch(fEventPattern) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"eventPattern\"=" + prettyPrintValue(fEventPattern)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fEventPattern == null) ? 0 : fEventPattern.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof NotPatternMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    NotPatternMatch other = (NotPatternMatch) obj;
    if (fEventPattern == null) {if (other.fEventPattern != null) return false;}
    else if (!fEventPattern.equals(other.fEventPattern)) return false;
    return true;
  }
  
  @Override
  public NotPatternQuerySpecification specification() {
    try {
    	return NotPatternQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static NotPatternMatch newEmptyMatch() {
    return new Mutable(null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static NotPatternMatch newMutableMatch(final ComplexEventPattern pEventPattern) {
    return new Mutable(pEventPattern);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static NotPatternMatch newMatch(final ComplexEventPattern pEventPattern) {
    return new Immutable(pEventPattern);
  }
  
  private static final class Mutable extends NotPatternMatch {
    Mutable(final ComplexEventPattern pEventPattern) {
      super(pEventPattern);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends NotPatternMatch {
    Immutable(final ComplexEventPattern pEventPattern) {
      super(pEventPattern);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
