/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.viatra.cep.core.engine.compiler.TransformationBasedCompiler;
import org.eclipse.viatra.cep.core.engine.compiler.rules.AtomicMappingRules;
import org.eclipse.viatra.cep.core.engine.compiler.rules.ComplexMappingRules;
import org.eclipse.viatra.cep.core.engine.compiler.rules.OptimizationRules;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.cep.core.metamodels.events.EventModel;
import org.eclipse.viatra.cep.core.metamodels.trace.TraceModel;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.SimpleModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.rules.BatchTransformationRuleGroup;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformation;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformationStatements;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class Pattern2AutomatonMapping {
  @Extension
  private AtomicMappingRules atomicMappingRules;
  
  @Extension
  private ComplexMappingRules complexMappingRules;
  
  @Extension
  private OptimizationRules optimizationRules;
  
  @Extension
  private BatchTransformation transformation;
  
  @Extension
  private BatchTransformationStatements statements;
  
  @Extension
  private IModelManipulations manipulation;
  
  private InternalModel internalModel;
  
  private EventModel eventModel;
  
  private TraceModel traceModel;
  
  public Pattern2AutomatonMapping(final ResourceSet resourceSet) {
    try {
      Resource _resource = resourceSet.getResource(TransformationBasedCompiler.AUTOMATON_MODEL_URI, true);
      EList<EObject> _contents = _resource.getContents();
      EObject _head = IterableExtensions.<EObject>head(_contents);
      this.internalModel = ((InternalModel) _head);
      Resource _resource_1 = resourceSet.getResource(TransformationBasedCompiler.EVENT_MODEL_URI, true);
      EList<EObject> _contents_1 = _resource_1.getContents();
      EObject _head_1 = IterableExtensions.<EObject>head(_contents_1);
      this.eventModel = ((EventModel) _head_1);
      Resource _resource_2 = resourceSet.getResource(TransformationBasedCompiler.TRACE_MODEL_URI, true);
      EList<EObject> _contents_2 = _resource_2.getContents();
      EObject _head_2 = IterableExtensions.<EObject>head(_contents_2);
      this.traceModel = ((TraceModel) _head_2);
      AtomicMappingRules _atomicMappingRules = new AtomicMappingRules(this.internalModel, this.traceModel);
      this.atomicMappingRules = _atomicMappingRules;
      ComplexMappingRules _complexMappingRules = new ComplexMappingRules(this.internalModel, this.traceModel);
      this.complexMappingRules = _complexMappingRules;
      OptimizationRules _optimizationRules = new OptimizationRules(this.internalModel, this.traceModel);
      this.optimizationRules = _optimizationRules;
      EMFScope _eMFScope = new EMFScope(resourceSet);
      BatchTransformation.BatchTransformationBuilder _forScope = BatchTransformation.forScope(_eMFScope);
      BatchTransformation _build = _forScope.build();
      this.transformation = _build;
      BatchTransformationStatements _transformationStatements = this.transformation.getTransformationStatements();
      this.statements = _transformationStatements;
      ViatraQueryEngine _queryEngine = this.transformation.getQueryEngine();
      SimpleModelManipulations _simpleModelManipulations = new SimpleModelManipulations(_queryEngine);
      this.manipulation = _simpleModelManipulations;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void mapPatterns() {
    final BatchTransformationRuleGroup ruleGroup = new BatchTransformationRuleGroup();
    List<? extends BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>> _allRules = this.atomicMappingRules.getAllRules();
    ruleGroup.addAll(_allRules);
    List<? extends BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>> _allRules_1 = this.complexMappingRules.getAllRules();
    ruleGroup.addAll(_allRules_1);
    List<? extends BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>> _allRules_2 = this.optimizationRules.getAllRules();
    ruleGroup.addAll(_allRules_2);
    this.statements.fireWhilePossible(ruleGroup);
  }
}
