/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.epsilonTransition pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class EpsilonTransitionProcessor implements IMatchProcessor<EpsilonTransitionMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * @param pPreState the value of pattern parameter preState in the currently processed match
   * @param pPostState the value of pattern parameter postState in the currently processed match
   * 
   */
  public abstract void process(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState);
  
  @Override
  public void process(final EpsilonTransitionMatch match) {
    process(match.getAutomaton(), match.getTransition(), match.getPreState(), match.getPostState());
  }
}
