/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.runtime.util.EnabledTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.Event;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.enabledTransition pattern,
 * to be used in conjunction with {@link EnabledTransitionMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see EnabledTransitionMatcher
 * @see EnabledTransitionProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class EnabledTransitionMatch extends BasePatternMatch {
  private TypedTransition fTransition;
  
  private EventToken fEventToken;
  
  private Event fEvent;
  
  private Automaton fAutomaton;
  
  private static List<String> parameterNames = makeImmutableList("transition", "eventToken", "event", "automaton");
  
  private EnabledTransitionMatch(final TypedTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    this.fTransition = pTransition;
    this.fEventToken = pEventToken;
    this.fEvent = pEvent;
    this.fAutomaton = pAutomaton;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("transition".equals(parameterName)) return this.fTransition;
    if ("eventToken".equals(parameterName)) return this.fEventToken;
    if ("event".equals(parameterName)) return this.fEvent;
    if ("automaton".equals(parameterName)) return this.fAutomaton;
    return null;
  }
  
  public TypedTransition getTransition() {
    return this.fTransition;
  }
  
  public EventToken getEventToken() {
    return this.fEventToken;
  }
  
  public Event getEvent() {
    return this.fEvent;
  }
  
  public Automaton getAutomaton() {
    return this.fAutomaton;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("transition".equals(parameterName) ) {
    	this.fTransition = (TypedTransition) newValue;
    	return true;
    }
    if ("eventToken".equals(parameterName) ) {
    	this.fEventToken = (EventToken) newValue;
    	return true;
    }
    if ("event".equals(parameterName) ) {
    	this.fEvent = (Event) newValue;
    	return true;
    }
    if ("automaton".equals(parameterName) ) {
    	this.fAutomaton = (Automaton) newValue;
    	return true;
    }
    return false;
  }
  
  public void setTransition(final TypedTransition pTransition) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition = pTransition;
  }
  
  public void setEventToken(final EventToken pEventToken) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventToken = pEventToken;
  }
  
  public void setEvent(final Event pEvent) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEvent = pEvent;
  }
  
  public void setAutomaton(final Automaton pAutomaton) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fAutomaton = pAutomaton;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.enabledTransition";
  }
  
  @Override
  public List<String> parameterNames() {
    return EnabledTransitionMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fTransition, fEventToken, fEvent, fAutomaton};
  }
  
  @Override
  public EnabledTransitionMatch toImmutable() {
    return isMutable() ? newMatch(fTransition, fEventToken, fEvent, fAutomaton) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"transition\"=" + prettyPrintValue(fTransition) + ", ");
    
    result.append("\"eventToken\"=" + prettyPrintValue(fEventToken) + ", ");
    
    result.append("\"event\"=" + prettyPrintValue(fEvent) + ", ");
    
    result.append("\"automaton\"=" + prettyPrintValue(fAutomaton)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fTransition == null) ? 0 : fTransition.hashCode());
    result = prime * result + ((fEventToken == null) ? 0 : fEventToken.hashCode());
    result = prime * result + ((fEvent == null) ? 0 : fEvent.hashCode());
    result = prime * result + ((fAutomaton == null) ? 0 : fAutomaton.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof EnabledTransitionMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    EnabledTransitionMatch other = (EnabledTransitionMatch) obj;
    if (fTransition == null) {if (other.fTransition != null) return false;}
    else if (!fTransition.equals(other.fTransition)) return false;
    if (fEventToken == null) {if (other.fEventToken != null) return false;}
    else if (!fEventToken.equals(other.fEventToken)) return false;
    if (fEvent == null) {if (other.fEvent != null) return false;}
    else if (!fEvent.equals(other.fEvent)) return false;
    if (fAutomaton == null) {if (other.fAutomaton != null) return false;}
    else if (!fAutomaton.equals(other.fAutomaton)) return false;
    return true;
  }
  
  @Override
  public EnabledTransitionQuerySpecification specification() {
    try {
    	return EnabledTransitionQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static EnabledTransitionMatch newEmptyMatch() {
    return new Mutable(null, null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static EnabledTransitionMatch newMutableMatch(final TypedTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return new Mutable(pTransition, pEventToken, pEvent, pAutomaton);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static EnabledTransitionMatch newMatch(final TypedTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
    return new Immutable(pTransition, pEventToken, pEvent, pAutomaton);
  }
  
  private static final class Mutable extends EnabledTransitionMatch {
    Mutable(final TypedTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
      super(pTransition, pEventToken, pEvent, pAutomaton);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends EnabledTransitionMatch {
    Immutable(final TypedTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton) {
      super(pTransition, pEventToken, pEvent, pAutomaton);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
