/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.runtime.util.EventProcessedByEventTokenQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.events.Event;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.eventProcessedByEventToken pattern,
 * to be used in conjunction with {@link EventProcessedByEventTokenMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see EventProcessedByEventTokenMatcher
 * @see EventProcessedByEventTokenProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class EventProcessedByEventTokenMatch extends BasePatternMatch {
  private Event fEvent;
  
  private EventToken fEventToken;
  
  private static List<String> parameterNames = makeImmutableList("event", "eventToken");
  
  private EventProcessedByEventTokenMatch(final Event pEvent, final EventToken pEventToken) {
    this.fEvent = pEvent;
    this.fEventToken = pEventToken;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("event".equals(parameterName)) return this.fEvent;
    if ("eventToken".equals(parameterName)) return this.fEventToken;
    return null;
  }
  
  public Event getEvent() {
    return this.fEvent;
  }
  
  public EventToken getEventToken() {
    return this.fEventToken;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("event".equals(parameterName) ) {
    	this.fEvent = (Event) newValue;
    	return true;
    }
    if ("eventToken".equals(parameterName) ) {
    	this.fEventToken = (EventToken) newValue;
    	return true;
    }
    return false;
  }
  
  public void setEvent(final Event pEvent) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEvent = pEvent;
  }
  
  public void setEventToken(final EventToken pEventToken) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventToken = pEventToken;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.eventProcessedByEventToken";
  }
  
  @Override
  public List<String> parameterNames() {
    return EventProcessedByEventTokenMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fEvent, fEventToken};
  }
  
  @Override
  public EventProcessedByEventTokenMatch toImmutable() {
    return isMutable() ? newMatch(fEvent, fEventToken) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"event\"=" + prettyPrintValue(fEvent) + ", ");
    
    result.append("\"eventToken\"=" + prettyPrintValue(fEventToken)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fEvent == null) ? 0 : fEvent.hashCode());
    result = prime * result + ((fEventToken == null) ? 0 : fEventToken.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof EventProcessedByEventTokenMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    EventProcessedByEventTokenMatch other = (EventProcessedByEventTokenMatch) obj;
    if (fEvent == null) {if (other.fEvent != null) return false;}
    else if (!fEvent.equals(other.fEvent)) return false;
    if (fEventToken == null) {if (other.fEventToken != null) return false;}
    else if (!fEventToken.equals(other.fEventToken)) return false;
    return true;
  }
  
  @Override
  public EventProcessedByEventTokenQuerySpecification specification() {
    try {
    	return EventProcessedByEventTokenQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static EventProcessedByEventTokenMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static EventProcessedByEventTokenMatch newMutableMatch(final Event pEvent, final EventToken pEventToken) {
    return new Mutable(pEvent, pEventToken);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static EventProcessedByEventTokenMatch newMatch(final Event pEvent, final EventToken pEventToken) {
    return new Immutable(pEvent, pEventToken);
  }
  
  private static final class Mutable extends EventProcessedByEventTokenMatch {
    Mutable(final Event pEvent, final EventToken pEventToken) {
      super(pEvent, pEventToken);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends EventProcessedByEventTokenMatch {
    Immutable(final Event pEvent, final EventToken pEventToken) {
      super(pEvent, pEventToken);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
