/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.runtime.EventProcessedByEventTokenMatch;
import org.eclipse.viatra.cep.core.engine.runtime.util.EventProcessedByEventTokenQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.events.Event;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.runtime.eventProcessedByEventToken pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link EventProcessedByEventTokenMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern eventProcessedByEventToken(event : Event, eventToken : EventToken) {
 * 	EventToken.lastProcessed(eventToken, event);
 * }
 * </pre></code>
 * 
 * @see EventProcessedByEventTokenMatch
 * @see EventProcessedByEventTokenProcessor
 * @see EventProcessedByEventTokenQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class EventProcessedByEventTokenMatcher extends BaseMatcher<EventProcessedByEventTokenMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EventProcessedByEventTokenMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    EventProcessedByEventTokenMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (EventProcessedByEventTokenMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EventProcessedByEventTokenMatcher create() throws ViatraQueryException {
    return new EventProcessedByEventTokenMatcher();
  }
  
  private final static int POSITION_EVENT = 0;
  
  private final static int POSITION_EVENTTOKEN = 1;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(EventProcessedByEventTokenMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private EventProcessedByEventTokenMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return matches represented as a EventProcessedByEventTokenMatch object.
   * 
   */
  public Collection<EventProcessedByEventTokenMatch> getAllMatches(final Event pEvent, final EventToken pEventToken) {
    return rawGetAllMatches(new Object[]{pEvent, pEventToken});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return a match represented as a EventProcessedByEventTokenMatch object, or null if no match is found.
   * 
   */
  public EventProcessedByEventTokenMatch getOneArbitraryMatch(final Event pEvent, final EventToken pEventToken) {
    return rawGetOneArbitraryMatch(new Object[]{pEvent, pEventToken});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Event pEvent, final EventToken pEventToken) {
    return rawHasMatch(new Object[]{pEvent, pEventToken});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Event pEvent, final EventToken pEventToken) {
    return rawCountMatches(new Object[]{pEvent, pEventToken});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Event pEvent, final EventToken pEventToken, final IMatchProcessor<? super EventProcessedByEventTokenMatch> processor) {
    rawForEachMatch(new Object[]{pEvent, pEventToken}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Event pEvent, final EventToken pEventToken, final IMatchProcessor<? super EventProcessedByEventTokenMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pEvent, pEventToken}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEvent the fixed value of pattern parameter event, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public EventProcessedByEventTokenMatch newMatch(final Event pEvent, final EventToken pEventToken) {
    return EventProcessedByEventTokenMatch.newMatch(pEvent, pEventToken);
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Event> rawAccumulateAllValuesOfevent(final Object[] parameters) {
    Set<Event> results = new HashSet<Event>();
    rawAccumulateAllValues(POSITION_EVENT, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Event> getAllValuesOfevent() {
    return rawAccumulateAllValuesOfevent(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Event> getAllValuesOfevent(final EventProcessedByEventTokenMatch partialMatch) {
    return rawAccumulateAllValuesOfevent(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for event.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Event> getAllValuesOfevent(final EventToken pEventToken) {
    return rawAccumulateAllValuesOfevent(new Object[]{
    null, 
    pEventToken
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EventToken> rawAccumulateAllValuesOfeventToken(final Object[] parameters) {
    Set<EventToken> results = new HashSet<EventToken>();
    rawAccumulateAllValues(POSITION_EVENTTOKEN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken() {
    return rawAccumulateAllValuesOfeventToken(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final EventProcessedByEventTokenMatch partialMatch) {
    return rawAccumulateAllValuesOfeventToken(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final Event pEvent) {
    return rawAccumulateAllValuesOfeventToken(new Object[]{
    pEvent, 
    null
    });
  }
  
  @Override
  protected EventProcessedByEventTokenMatch tupleToMatch(final Tuple t) {
    try {
    	return EventProcessedByEventTokenMatch.newMatch((Event) t.get(POSITION_EVENT), (EventToken) t.get(POSITION_EVENTTOKEN));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EventProcessedByEventTokenMatch arrayToMatch(final Object[] match) {
    try {
    	return EventProcessedByEventTokenMatch.newMatch((Event) match[POSITION_EVENT], (EventToken) match[POSITION_EVENTTOKEN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EventProcessedByEventTokenMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return EventProcessedByEventTokenMatch.newMutableMatch((Event) match[POSITION_EVENT], (EventToken) match[POSITION_EVENTTOKEN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<EventProcessedByEventTokenMatcher> querySpecification() throws ViatraQueryException {
    return EventProcessedByEventTokenQuerySpecification.instance();
  }
}
