/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.engine.runtime.EnabledTransitionMatch;
import org.eclipse.viatra.cep.core.engine.runtime.EnabledTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.util.EventProcessedByEventTokenQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.LatestEventQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate EnabledTransitionMatcher in a type-safe way.
 * 
 * @see EnabledTransitionMatcher
 * @see EnabledTransitionMatch
 * 
 */
@SuppressWarnings("all")
public final class EnabledTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<EnabledTransitionMatcher> {
  private EnabledTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static EnabledTransitionQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected EnabledTransitionMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EnabledTransitionMatcher.on(engine);
  }
  
  @Override
  public EnabledTransitionMatcher instantiate() throws ViatraQueryException {
    return EnabledTransitionMatcher.create();
  }
  
  @Override
  public EnabledTransitionMatch newEmptyMatch() {
    return EnabledTransitionMatch.newEmptyMatch();
  }
  
  @Override
  public EnabledTransitionMatch newMatch(final Object... parameters) {
    return EnabledTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[1], (org.eclipse.viatra.cep.core.metamodels.events.Event) parameters[2], (org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[3]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link EnabledTransitionQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link EnabledTransitionQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static EnabledTransitionQuerySpecification INSTANCE = new EnabledTransitionQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static EnabledTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pTransition = new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TypedTransition")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pEventToken = new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "EventToken")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pEvent = new PParameter("event", "org.eclipse.viatra.cep.core.metamodels.events.Event", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("cep.meta", "Event")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pAutomaton = new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "Automaton")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pTransition, parameter_pEventToken, parameter_pEvent, parameter_pAutomaton);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.enabledTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("transition","eventToken","event","automaton");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		PVariable var_event = body.getOrCreateVariableByName("event");
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_eventType = body.getOrCreateVariableByName("eventType");
      		PVariable var_eventPatternReference = body.getOrCreateVariableByName("eventPatternReference");
      		PVariable var_state = body.getOrCreateVariableByName("state");
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		new TypeConstraint(body, new FlatTuple(var_event), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "Event")));
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition, parameter_pTransition),
      		   new ExportedParameter(body, var_eventToken, parameter_pEventToken),
      		   new ExportedParameter(body, var_event, parameter_pEvent),
      		   new ExportedParameter(body, var_automaton, parameter_pAutomaton)
      		));
      		// 	find latestEvent(event)
      		new PositivePatternCall(body, new FlatTuple(var_event), LatestEventQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	Event.type(event, eventType)
      		new TypeConstraint(body, new FlatTuple(var_event), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "Event")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_event, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "Event", "type")));
      		new Equality(body, var__virtual_0_, var_eventType);
      		// 	TypedTransition.guards.eventType(transition, eventPatternReference)
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_transition, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var__virtual_1_, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_2_, var_eventPatternReference);
      		// 	AtomicEventPattern.type(eventPatternReference, eventType)
      		new TypeConstraint(body, new FlatTuple(var_eventPatternReference), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "AtomicEventPattern")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_eventPatternReference, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "AtomicEventPattern", "type")));
      		new Equality(body, var__virtual_3_, var_eventType);
      		// 	TypedTransition.preState.eventTokens(transition, eventToken)
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_transition, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "preState")));
      		PVariable var__virtual_5_ = body.getOrCreateVariableByName(".virtual{5}");
      		new TypeConstraint(body, new FlatTuple(var__virtual_4_, var__virtual_5_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "eventTokens")));
      		new Equality(body, var__virtual_5_, var_eventToken);
      		// 	neg find negativeTransition(transition)
      		new NegativePatternCall(body, new FlatTuple(var_transition), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	neg find eventProcessedByEventToken(event, eventToken)
      		new NegativePatternCall(body, new FlatTuple(var_event, var_eventToken), EventProcessedByEventTokenQuerySpecification.instance().getInternalQueryRepresentation());
      		// 		Automaton.states(automaton, state)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_6_ = body.getOrCreateVariableByName(".virtual{6}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_6_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_6_, var_state);
      		// 	State.outTransitions(state, transition)
      		new TypeConstraint(body, new FlatTuple(var_state), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_7_ = body.getOrCreateVariableByName(".virtual{7}");
      		new TypeConstraint(body, new FlatTuple(var_state, var__virtual_7_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "outTransitions")));
      		new Equality(body, var__virtual_7_, var_transition);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
