/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexAndTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexAndTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.complexAndTransition pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
 * e.g. in conjunction with {@link ViatraQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link ComplexAndTransitionMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern
 * complexAndTransition(automaton : Automaton, transition : TypedTransition, eventPattern : ComplexEventPattern) {
 * 	find complexTransition(automaton, transition, eventPattern, operator);
 * 	neg find negativeTransition(transition);
 * 	AND(operator);
 * }
 * </pre></code>
 * 
 * @see ComplexAndTransitionMatch
 * @see ComplexAndTransitionProcessor
 * @see ComplexAndTransitionQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class ComplexAndTransitionMatcher extends BaseMatcher<ComplexAndTransitionMatch> {
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static ComplexAndTransitionMatcher on(final ViatraQueryEngine engine) throws ViatraQueryException {
    // check if matcher already exists
    ComplexAndTransitionMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = (ComplexAndTransitionMatcher)engine.getMatcher(querySpecification());
    }
    return matcher;
  }
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static ComplexAndTransitionMatcher create() throws ViatraQueryException {
    return new ComplexAndTransitionMatcher();
  }
  
  private final static int POSITION_AUTOMATON = 0;
  
  private final static int POSITION_TRANSITION = 1;
  
  private final static int POSITION_EVENTPATTERN = 2;
  
  private final static Logger LOGGER = ViatraQueryLoggingUtil.getLogger(ComplexAndTransitionMatcher.class);
  
  /**
   * Initializes the pattern matcher within an existing VIATRA Query engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing VIATRA Query engine in which this matcher will be created.
   * @throws ViatraQueryException if an error occurs during pattern matcher creation
   * 
   */
  private ComplexAndTransitionMatcher() throws ViatraQueryException {
    super(querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return matches represented as a ComplexAndTransitionMatch object.
   * 
   */
  public Collection<ComplexAndTransitionMatch> getAllMatches(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawGetAllMatches(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return a match represented as a ComplexAndTransitionMatch object, or null if no match is found.
   * 
   */
  public ComplexAndTransitionMatch getOneArbitraryMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawGetOneArbitraryMatch(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawHasMatch(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawCountMatches(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern, final IMatchProcessor<? super ComplexAndTransitionMatch> processor) {
    rawForEachMatch(new Object[]{pAutomaton, pTransition, pEventPattern}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern, final IMatchProcessor<? super ComplexAndTransitionMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pAutomaton, pTransition, pEventPattern}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public ComplexAndTransitionMatch newMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return ComplexAndTransitionMatch.newMatch(pAutomaton, pTransition, pEventPattern);
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Automaton> rawAccumulateAllValuesOfautomaton(final Object[] parameters) {
    Set<Automaton> results = new HashSet<Automaton>();
    rawAccumulateAllValues(POSITION_AUTOMATON, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton() {
    return rawAccumulateAllValuesOfautomaton(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final ComplexAndTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfautomaton(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawAccumulateAllValuesOfautomaton(new Object[]{
    null, 
    pTransition, 
    pEventPattern
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TypedTransition> rawAccumulateAllValuesOftransition(final Object[] parameters) {
    Set<TypedTransition> results = new HashSet<TypedTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition() {
    return rawAccumulateAllValuesOftransition(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition(final ComplexAndTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOftransition(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition(final Automaton pAutomaton, final ComplexEventPattern pEventPattern) {
    return rawAccumulateAllValuesOftransition(new Object[]{
    pAutomaton, 
    null, 
    pEventPattern
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<ComplexEventPattern> rawAccumulateAllValuesOfeventPattern(final Object[] parameters) {
    Set<ComplexEventPattern> results = new HashSet<ComplexEventPattern>();
    rawAccumulateAllValues(POSITION_EVENTPATTERN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ComplexEventPattern> getAllValuesOfeventPattern() {
    return rawAccumulateAllValuesOfeventPattern(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ComplexEventPattern> getAllValuesOfeventPattern(final ComplexAndTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfeventPattern(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ComplexEventPattern> getAllValuesOfeventPattern(final Automaton pAutomaton, final TypedTransition pTransition) {
    return rawAccumulateAllValuesOfeventPattern(new Object[]{
    pAutomaton, 
    pTransition, 
    null
    });
  }
  
  @Override
  protected ComplexAndTransitionMatch tupleToMatch(final Tuple t) {
    try {
    	return ComplexAndTransitionMatch.newMatch((Automaton) t.get(POSITION_AUTOMATON), (TypedTransition) t.get(POSITION_TRANSITION), (ComplexEventPattern) t.get(POSITION_EVENTPATTERN));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ComplexAndTransitionMatch arrayToMatch(final Object[] match) {
    try {
    	return ComplexAndTransitionMatch.newMatch((Automaton) match[POSITION_AUTOMATON], (TypedTransition) match[POSITION_TRANSITION], (ComplexEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ComplexAndTransitionMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return ComplexAndTransitionMatch.newMutableMatch((Automaton) match[POSITION_AUTOMATON], (TypedTransition) match[POSITION_TRANSITION], (ComplexEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<ComplexAndTransitionMatcher> querySpecification() throws ViatraQueryException {
    return ComplexAndTransitionQuerySpecification.instance();
  }
}
