/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.compiler.util.EpsilonTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.compiler.epsilonTransition pattern,
 * to be used in conjunction with {@link EpsilonTransitionMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see EpsilonTransitionMatcher
 * @see EpsilonTransitionProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class EpsilonTransitionMatch extends BasePatternMatch {
  private Automaton fAutomaton;
  
  private EpsilonTransition fTransition;
  
  private State fPreState;
  
  private State fPostState;
  
  private static List<String> parameterNames = makeImmutableList("automaton", "transition", "preState", "postState");
  
  private EpsilonTransitionMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    this.fAutomaton = pAutomaton;
    this.fTransition = pTransition;
    this.fPreState = pPreState;
    this.fPostState = pPostState;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("automaton".equals(parameterName)) return this.fAutomaton;
    if ("transition".equals(parameterName)) return this.fTransition;
    if ("preState".equals(parameterName)) return this.fPreState;
    if ("postState".equals(parameterName)) return this.fPostState;
    return null;
  }
  
  public Automaton getAutomaton() {
    return this.fAutomaton;
  }
  
  public EpsilonTransition getTransition() {
    return this.fTransition;
  }
  
  public State getPreState() {
    return this.fPreState;
  }
  
  public State getPostState() {
    return this.fPostState;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("automaton".equals(parameterName) ) {
    	this.fAutomaton = (Automaton) newValue;
    	return true;
    }
    if ("transition".equals(parameterName) ) {
    	this.fTransition = (EpsilonTransition) newValue;
    	return true;
    }
    if ("preState".equals(parameterName) ) {
    	this.fPreState = (State) newValue;
    	return true;
    }
    if ("postState".equals(parameterName) ) {
    	this.fPostState = (State) newValue;
    	return true;
    }
    return false;
  }
  
  public void setAutomaton(final Automaton pAutomaton) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fAutomaton = pAutomaton;
  }
  
  public void setTransition(final EpsilonTransition pTransition) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition = pTransition;
  }
  
  public void setPreState(final State pPreState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPreState = pPreState;
  }
  
  public void setPostState(final State pPostState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPostState = pPostState;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.compiler.epsilonTransition";
  }
  
  @Override
  public List<String> parameterNames() {
    return EpsilonTransitionMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fAutomaton, fTransition, fPreState, fPostState};
  }
  
  @Override
  public EpsilonTransitionMatch toImmutable() {
    return isMutable() ? newMatch(fAutomaton, fTransition, fPreState, fPostState) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"automaton\"=" + prettyPrintValue(fAutomaton) + ", ");
    
    result.append("\"transition\"=" + prettyPrintValue(fTransition) + ", ");
    
    result.append("\"preState\"=" + prettyPrintValue(fPreState) + ", ");
    
    result.append("\"postState\"=" + prettyPrintValue(fPostState)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fAutomaton == null) ? 0 : fAutomaton.hashCode());
    result = prime * result + ((fTransition == null) ? 0 : fTransition.hashCode());
    result = prime * result + ((fPreState == null) ? 0 : fPreState.hashCode());
    result = prime * result + ((fPostState == null) ? 0 : fPostState.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof EpsilonTransitionMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    EpsilonTransitionMatch other = (EpsilonTransitionMatch) obj;
    if (fAutomaton == null) {if (other.fAutomaton != null) return false;}
    else if (!fAutomaton.equals(other.fAutomaton)) return false;
    if (fTransition == null) {if (other.fTransition != null) return false;}
    else if (!fTransition.equals(other.fTransition)) return false;
    if (fPreState == null) {if (other.fPreState != null) return false;}
    else if (!fPreState.equals(other.fPreState)) return false;
    if (fPostState == null) {if (other.fPostState != null) return false;}
    else if (!fPostState.equals(other.fPostState)) return false;
    return true;
  }
  
  @Override
  public EpsilonTransitionQuerySpecification specification() {
    try {
    	return EpsilonTransitionQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static EpsilonTransitionMatch newEmptyMatch() {
    return new Mutable(null, null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static EpsilonTransitionMatch newMutableMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return new Mutable(pAutomaton, pTransition, pPreState, pPostState);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static EpsilonTransitionMatch newMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return new Immutable(pAutomaton, pTransition, pPreState, pPostState);
  }
  
  private static final class Mutable extends EpsilonTransitionMatch {
    Mutable(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
      super(pAutomaton, pTransition, pPreState, pPostState);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends EpsilonTransitionMatch {
    Immutable(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
      super(pAutomaton, pTransition, pPreState, pPostState);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
