/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentStatesQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.compiler.equivalentStates pattern,
 * to be used in conjunction with {@link EquivalentStatesMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see EquivalentStatesMatcher
 * @see EquivalentStatesProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class EquivalentStatesMatch extends BasePatternMatch {
  private TypedTransition fTransition1;
  
  private TypedTransition fTransition2;
  
  private State fPreState;
  
  private State fPostState1;
  
  private State fPostState2;
  
  private static List<String> parameterNames = makeImmutableList("transition1", "transition2", "preState", "postState1", "postState2");
  
  private EquivalentStatesMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    this.fTransition1 = pTransition1;
    this.fTransition2 = pTransition2;
    this.fPreState = pPreState;
    this.fPostState1 = pPostState1;
    this.fPostState2 = pPostState2;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("transition1".equals(parameterName)) return this.fTransition1;
    if ("transition2".equals(parameterName)) return this.fTransition2;
    if ("preState".equals(parameterName)) return this.fPreState;
    if ("postState1".equals(parameterName)) return this.fPostState1;
    if ("postState2".equals(parameterName)) return this.fPostState2;
    return null;
  }
  
  public TypedTransition getTransition1() {
    return this.fTransition1;
  }
  
  public TypedTransition getTransition2() {
    return this.fTransition2;
  }
  
  public State getPreState() {
    return this.fPreState;
  }
  
  public State getPostState1() {
    return this.fPostState1;
  }
  
  public State getPostState2() {
    return this.fPostState2;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("transition1".equals(parameterName) ) {
    	this.fTransition1 = (TypedTransition) newValue;
    	return true;
    }
    if ("transition2".equals(parameterName) ) {
    	this.fTransition2 = (TypedTransition) newValue;
    	return true;
    }
    if ("preState".equals(parameterName) ) {
    	this.fPreState = (State) newValue;
    	return true;
    }
    if ("postState1".equals(parameterName) ) {
    	this.fPostState1 = (State) newValue;
    	return true;
    }
    if ("postState2".equals(parameterName) ) {
    	this.fPostState2 = (State) newValue;
    	return true;
    }
    return false;
  }
  
  public void setTransition1(final TypedTransition pTransition1) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition1 = pTransition1;
  }
  
  public void setTransition2(final TypedTransition pTransition2) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition2 = pTransition2;
  }
  
  public void setPreState(final State pPreState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPreState = pPreState;
  }
  
  public void setPostState1(final State pPostState1) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPostState1 = pPostState1;
  }
  
  public void setPostState2(final State pPostState2) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fPostState2 = pPostState2;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.compiler.equivalentStates";
  }
  
  @Override
  public List<String> parameterNames() {
    return EquivalentStatesMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fTransition1, fTransition2, fPreState, fPostState1, fPostState2};
  }
  
  @Override
  public EquivalentStatesMatch toImmutable() {
    return isMutable() ? newMatch(fTransition1, fTransition2, fPreState, fPostState1, fPostState2) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"transition1\"=" + prettyPrintValue(fTransition1) + ", ");
    
    result.append("\"transition2\"=" + prettyPrintValue(fTransition2) + ", ");
    
    result.append("\"preState\"=" + prettyPrintValue(fPreState) + ", ");
    
    result.append("\"postState1\"=" + prettyPrintValue(fPostState1) + ", ");
    
    result.append("\"postState2\"=" + prettyPrintValue(fPostState2)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fTransition1 == null) ? 0 : fTransition1.hashCode());
    result = prime * result + ((fTransition2 == null) ? 0 : fTransition2.hashCode());
    result = prime * result + ((fPreState == null) ? 0 : fPreState.hashCode());
    result = prime * result + ((fPostState1 == null) ? 0 : fPostState1.hashCode());
    result = prime * result + ((fPostState2 == null) ? 0 : fPostState2.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof EquivalentStatesMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    EquivalentStatesMatch other = (EquivalentStatesMatch) obj;
    if (fTransition1 == null) {if (other.fTransition1 != null) return false;}
    else if (!fTransition1.equals(other.fTransition1)) return false;
    if (fTransition2 == null) {if (other.fTransition2 != null) return false;}
    else if (!fTransition2.equals(other.fTransition2)) return false;
    if (fPreState == null) {if (other.fPreState != null) return false;}
    else if (!fPreState.equals(other.fPreState)) return false;
    if (fPostState1 == null) {if (other.fPostState1 != null) return false;}
    else if (!fPostState1.equals(other.fPostState1)) return false;
    if (fPostState2 == null) {if (other.fPostState2 != null) return false;}
    else if (!fPostState2.equals(other.fPostState2)) return false;
    return true;
  }
  
  @Override
  public EquivalentStatesQuerySpecification specification() {
    try {
    	return EquivalentStatesQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static EquivalentStatesMatch newEmptyMatch() {
    return new Mutable(null, null, null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static EquivalentStatesMatch newMutableMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return new Mutable(pTransition1, pTransition2, pPreState, pPostState1, pPostState2);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState1 the fixed value of pattern parameter postState1, or null if not bound.
   * @param pPostState2 the fixed value of pattern parameter postState2, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static EquivalentStatesMatch newMatch(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
    return new Immutable(pTransition1, pTransition2, pPreState, pPostState1, pPostState2);
  }
  
  private static final class Mutable extends EquivalentStatesMatch {
    Mutable(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
      super(pTransition1, pTransition2, pPreState, pPostState1, pPostState2);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends EquivalentStatesMatch {
    Immutable(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2) {
      super(pTransition1, pTransition2, pPreState, pPostState1, pPostState2);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
