/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.engine.compiler.rules;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.cep.core.engine.compiler.AndPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.AndPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexAndTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexAndTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexFollowsTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexFollowsTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexNotTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexOrTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexOrTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.FollowsPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.FollowsPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NonUnfoldedNotTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.NonUnfoldedNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NotPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.NotPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.OrPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.OrPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.builders.BuilderPrimitives;
import org.eclipse.viatra.cep.core.engine.compiler.builders.ComplexMappingUtils;
import org.eclipse.viatra.cep.core.engine.compiler.rules.MappingRules;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.FinalState;
import org.eclipse.viatra.cep.core.metamodels.automaton.Guard;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.cep.core.metamodels.automaton.NegativeTransition;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.Transition;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.AND;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;
import org.eclipse.viatra.cep.core.metamodels.events.EventPattern;
import org.eclipse.viatra.cep.core.metamodels.events.EventPatternReference;
import org.eclipse.viatra.cep.core.metamodels.events.FOLLOWS;
import org.eclipse.viatra.cep.core.metamodels.events.OR;
import org.eclipse.viatra.cep.core.metamodels.trace.TraceModel;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ComplexMappingRules extends MappingRules {
  @Extension
  private final ComplexMappingUtils complexMappingUtils;
  
  @Extension
  private final BuilderPrimitives builderPrimitives;
  
  public ComplexMappingRules(final InternalModel internalModel, final TraceModel traceModel) {
    super(internalModel, traceModel);
    ComplexMappingUtils _complexMappingUtils = new ComplexMappingUtils(traceModel);
    this.complexMappingUtils = _complexMappingUtils;
    BuilderPrimitives _builderPrimitives = new BuilderPrimitives(traceModel);
    this.builderPrimitives = _builderPrimitives;
  }
  
  @Override
  public List<? extends BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>> getAllRules() {
    return Collections.<BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>>unmodifiableList(CollectionLiterals.<BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>>newArrayList(this.notPattern2AutomatonRule, this.notUnfoldRule, this.negativeTransitionUnfoldRule, this.followsPattern2AutomatonRule, this.orPattern2AutomatonRule, this.followUnfoldRule, this.orUnfoldRule, this.andPattern2AutomatonRule, this.andUnfoldRule));
  }
  
  /**
   * Transformation rule to compile {@link ComplexEventPattern}s with a {@link FOLLOWS} operator to {@link Automaton}.
   */
  private final BatchTransformationRule<FollowsPatternMatch, FollowsPatternMatcher> followsPattern2AutomatonRule = new Function0<BatchTransformationRule<FollowsPatternMatch, FollowsPatternMatcher>>() {
    public BatchTransformationRule<FollowsPatternMatch, FollowsPatternMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<FollowsPatternMatch, FollowsPatternMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<FollowsPatternMatch, FollowsPatternMatcher>createRule();
        IQuerySpecification<FollowsPatternMatcher> _querySpecification = FollowsPatternMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<FollowsPatternMatch, FollowsPatternMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<FollowsPatternMatch> _function = new IMatchProcessor<FollowsPatternMatch>() {
          @Override
          public void process(final FollowsPatternMatch it) {
            ComplexEventPattern _eventPattern = it.getEventPattern();
            final Automaton mappedAutomaton = ComplexMappingRules.this.checkForMappedAutomaton(_eventPattern);
            boolean _notEquals = (!Objects.equal(mappedAutomaton, null));
            if (_notEquals) {
              ComplexEventPattern _eventPattern_1 = it.getEventPattern();
              ComplexMappingRules.this.createTrace(_eventPattern_1, mappedAutomaton);
              return;
            }
            ComplexEventPattern _eventPattern_2 = it.getEventPattern();
            Automaton automaton = ComplexMappingRules.this.initializeAutomaton(_eventPattern_2);
            final FinalState finalState = ComplexMappingRules.this.automatonFactory.createFinalState();
            EList<State> _states = automaton.getStates();
            _states.add(finalState);
            ComplexEventPattern _eventPattern_3 = it.getEventPattern();
            InitState _initialState = automaton.getInitialState();
            ComplexMappingRules.this.complexMappingUtils.buildFollowsPath(automaton, _eventPattern_3, _initialState, finalState);
            ComplexEventPattern _eventPattern_4 = it.getEventPattern();
            ComplexMappingRules.this.createTrace(_eventPattern_4, automaton);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<FollowsPatternMatch, FollowsPatternMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<FollowsPatternMatch, FollowsPatternMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to unfold {@link Transition}s in an {@link Automaton} guarded by a
   * {@link ComplexEventPattern} with a {@link FOLLOWS} operator as a type.
   */
  private final BatchTransformationRule<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher> followUnfoldRule = new Function0<BatchTransformationRule<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher>>() {
    public BatchTransformationRule<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher>createRule();
        IQuerySpecification<ComplexFollowsTransitionMatcher> _querySpecification = ComplexFollowsTransitionMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<ComplexFollowsTransitionMatch> _function = new IMatchProcessor<ComplexFollowsTransitionMatch>() {
          @Override
          public void process(final ComplexFollowsTransitionMatch it) {
            TypedTransition _transition = it.getTransition();
            EList<Guard> _guards = _transition.getGuards();
            Guard _head = IterableExtensions.<Guard>head(_guards);
            EventPattern _eventType = _head.getEventType();
            final ComplexEventPattern referredEventPattern = ((ComplexEventPattern) _eventType);
            Automaton _automaton = it.getAutomaton();
            TypedTransition _transition_1 = it.getTransition();
            ComplexMappingRules.this.complexMappingUtils.unfoldFollowsPath(_automaton, referredEventPattern, _transition_1);
            TypedTransition _transition_2 = it.getTransition();
            ComplexMappingRules.this.builderPrimitives.removeTransition(_transition_2);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<ComplexFollowsTransitionMatch, ComplexFollowsTransitionMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to compile {@link ComplexEventPattern}s with an {@link OR} operator to {@link Automaton}.
   */
  private final BatchTransformationRule<OrPatternMatch, OrPatternMatcher> orPattern2AutomatonRule = new Function0<BatchTransformationRule<OrPatternMatch, OrPatternMatcher>>() {
    public BatchTransformationRule<OrPatternMatch, OrPatternMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<OrPatternMatch, OrPatternMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<OrPatternMatch, OrPatternMatcher>createRule();
        IQuerySpecification<OrPatternMatcher> _querySpecification = OrPatternMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<OrPatternMatch, OrPatternMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<OrPatternMatch> _function = new IMatchProcessor<OrPatternMatch>() {
          @Override
          public void process(final OrPatternMatch it) {
            ComplexEventPattern _eventPattern = it.getEventPattern();
            final Automaton mappedAutomaton = ComplexMappingRules.this.checkForMappedAutomaton(_eventPattern);
            boolean _notEquals = (!Objects.equal(mappedAutomaton, null));
            if (_notEquals) {
              ComplexEventPattern _eventPattern_1 = it.getEventPattern();
              ComplexMappingRules.this.createTrace(_eventPattern_1, mappedAutomaton);
              return;
            }
            ComplexEventPattern _eventPattern_2 = it.getEventPattern();
            Automaton automaton = ComplexMappingRules.this.initializeAutomaton(_eventPattern_2);
            final FinalState finalState = ComplexMappingRules.this.automatonFactory.createFinalState();
            EList<State> _states = automaton.getStates();
            _states.add(finalState);
            ComplexEventPattern _eventPattern_3 = it.getEventPattern();
            InitState _initialState = automaton.getInitialState();
            ComplexMappingRules.this.complexMappingUtils.buildOrPath(automaton, _eventPattern_3, _initialState, finalState);
            ComplexEventPattern _eventPattern_4 = it.getEventPattern();
            ComplexMappingRules.this.createTrace(_eventPattern_4, automaton);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<OrPatternMatch, OrPatternMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<OrPatternMatch, OrPatternMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to unfold {@link Transition}s in an {@link Automaton} guarded by a
   * {@link ComplexEventPattern} with an {@link OR} operator as a type.
   */
  private final BatchTransformationRule<ComplexOrTransitionMatch, ComplexOrTransitionMatcher> orUnfoldRule = new Function0<BatchTransformationRule<ComplexOrTransitionMatch, ComplexOrTransitionMatcher>>() {
    public BatchTransformationRule<ComplexOrTransitionMatch, ComplexOrTransitionMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexOrTransitionMatch, ComplexOrTransitionMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<ComplexOrTransitionMatch, ComplexOrTransitionMatcher>createRule();
        IQuerySpecification<ComplexOrTransitionMatcher> _querySpecification = ComplexOrTransitionMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexOrTransitionMatch, ComplexOrTransitionMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<ComplexOrTransitionMatch> _function = new IMatchProcessor<ComplexOrTransitionMatch>() {
          @Override
          public void process(final ComplexOrTransitionMatch it) {
            TypedTransition _transition = it.getTransition();
            EList<Guard> _guards = _transition.getGuards();
            Guard _head = IterableExtensions.<Guard>head(_guards);
            EventPattern _eventType = _head.getEventType();
            final ComplexEventPattern referredEventPattern = ((ComplexEventPattern) _eventType);
            Automaton _automaton = it.getAutomaton();
            TypedTransition _transition_1 = it.getTransition();
            ComplexMappingRules.this.complexMappingUtils.unfoldOrPath(_automaton, referredEventPattern, _transition_1);
            TypedTransition _transition_2 = it.getTransition();
            ComplexMappingRules.this.builderPrimitives.removeTransition(_transition_2);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexOrTransitionMatch, ComplexOrTransitionMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<ComplexOrTransitionMatch, ComplexOrTransitionMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to compile {@link ComplexEventPattern}s with an {@link AND} operator to {@link Automaton}.
   */
  private final BatchTransformationRule<AndPatternMatch, AndPatternMatcher> andPattern2AutomatonRule = new Function0<BatchTransformationRule<AndPatternMatch, AndPatternMatcher>>() {
    public BatchTransformationRule<AndPatternMatch, AndPatternMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<AndPatternMatch, AndPatternMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<AndPatternMatch, AndPatternMatcher>createRule();
        IQuerySpecification<AndPatternMatcher> _querySpecification = AndPatternMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<AndPatternMatch, AndPatternMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<AndPatternMatch> _function = new IMatchProcessor<AndPatternMatch>() {
          @Override
          public void process(final AndPatternMatch it) {
            ComplexEventPattern _eventPattern = it.getEventPattern();
            final Automaton mappedAutomaton = ComplexMappingRules.this.checkForMappedAutomaton(_eventPattern);
            boolean _notEquals = (!Objects.equal(mappedAutomaton, null));
            if (_notEquals) {
              ComplexEventPattern _eventPattern_1 = it.getEventPattern();
              ComplexMappingRules.this.createTrace(_eventPattern_1, mappedAutomaton);
              return;
            }
            ComplexEventPattern _eventPattern_2 = it.getEventPattern();
            Automaton automaton = ComplexMappingRules.this.initializeAutomaton(_eventPattern_2);
            final FinalState finalState = ComplexMappingRules.this.automatonFactory.createFinalState();
            EList<State> _states = automaton.getStates();
            _states.add(finalState);
            ComplexEventPattern _eventPattern_3 = it.getEventPattern();
            InitState _initialState = automaton.getInitialState();
            ComplexMappingRules.this.complexMappingUtils.buildAndPath(automaton, _eventPattern_3, _initialState, finalState);
            ComplexEventPattern _eventPattern_4 = it.getEventPattern();
            ComplexMappingRules.this.createTrace(_eventPattern_4, automaton);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<AndPatternMatch, AndPatternMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<AndPatternMatch, AndPatternMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to unfold {@link Transition}s in an {@link Automaton} guarded by a
   * {@link ComplexEventPattern} with an {@link AND} operator as a type.
   */
  private final BatchTransformationRule<ComplexAndTransitionMatch, ComplexAndTransitionMatcher> andUnfoldRule = new Function0<BatchTransformationRule<ComplexAndTransitionMatch, ComplexAndTransitionMatcher>>() {
    public BatchTransformationRule<ComplexAndTransitionMatch, ComplexAndTransitionMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexAndTransitionMatch, ComplexAndTransitionMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<ComplexAndTransitionMatch, ComplexAndTransitionMatcher>createRule();
        IQuerySpecification<ComplexAndTransitionMatcher> _querySpecification = ComplexAndTransitionMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexAndTransitionMatch, ComplexAndTransitionMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<ComplexAndTransitionMatch> _function = new IMatchProcessor<ComplexAndTransitionMatch>() {
          @Override
          public void process(final ComplexAndTransitionMatch it) {
            TypedTransition _transition = it.getTransition();
            EList<Guard> _guards = _transition.getGuards();
            Guard _head = IterableExtensions.<Guard>head(_guards);
            EventPattern _eventType = _head.getEventType();
            final ComplexEventPattern referredEventPattern = ((ComplexEventPattern) _eventType);
            Automaton _automaton = it.getAutomaton();
            TypedTransition _transition_1 = it.getTransition();
            ComplexMappingRules.this.complexMappingUtils.unfoldAndPath(_automaton, referredEventPattern, _transition_1);
            TypedTransition _transition_2 = it.getTransition();
            ComplexMappingRules.this.builderPrimitives.removeTransition(_transition_2);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexAndTransitionMatch, ComplexAndTransitionMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<ComplexAndTransitionMatch, ComplexAndTransitionMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to compile {@link ComplexEventPattern}s with a {@link NOT} operator to {@link Automaton}.
   */
  private final BatchTransformationRule<NotPatternMatch, NotPatternMatcher> notPattern2AutomatonRule = new Function0<BatchTransformationRule<NotPatternMatch, NotPatternMatcher>>() {
    public BatchTransformationRule<NotPatternMatch, NotPatternMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<NotPatternMatch, NotPatternMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<NotPatternMatch, NotPatternMatcher>createRule();
        IQuerySpecification<NotPatternMatcher> _querySpecification = NotPatternMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<NotPatternMatch, NotPatternMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<NotPatternMatch> _function = new IMatchProcessor<NotPatternMatch>() {
          @Override
          public void process(final NotPatternMatch it) {
            ComplexEventPattern _eventPattern = it.getEventPattern();
            final Automaton mappedAutomaton = ComplexMappingRules.this.checkForMappedAutomaton(_eventPattern);
            boolean _notEquals = (!Objects.equal(mappedAutomaton, null));
            if (_notEquals) {
              ComplexEventPattern _eventPattern_1 = it.getEventPattern();
              ComplexMappingRules.this.createTrace(_eventPattern_1, mappedAutomaton);
              return;
            }
            ComplexEventPattern _eventPattern_2 = it.getEventPattern();
            Automaton automaton = ComplexMappingRules.this.initializeAutomaton(_eventPattern_2);
            final FinalState finalState = ComplexMappingRules.this.automatonFactory.createFinalState();
            EList<State> _states = automaton.getStates();
            _states.add(finalState);
            ComplexEventPattern _eventPattern_3 = it.getEventPattern();
            EList<EventPatternReference> _containedEventPatterns = _eventPattern_3.getContainedEventPatterns();
            int _size = _containedEventPatterns.size();
            boolean _equals = (_size == 1);
            Preconditions.checkArgument(_equals);
            ComplexEventPattern _eventPattern_4 = it.getEventPattern();
            EList<EventPatternReference> _containedEventPatterns_1 = _eventPattern_4.getContainedEventPatterns();
            EventPatternReference _head = IterableExtensions.<EventPatternReference>head(_containedEventPatterns_1);
            EventPattern _eventPattern_5 = _head.getEventPattern();
            InitState _initialState = automaton.getInitialState();
            ComplexMappingRules.this.complexMappingUtils.buildNotPath(automaton, _eventPattern_5, _initialState, finalState);
            ComplexEventPattern _eventPattern_6 = it.getEventPattern();
            ComplexMappingRules.this.createTrace(_eventPattern_6, automaton);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<NotPatternMatch, NotPatternMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<NotPatternMatch, NotPatternMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to unfold {@link TypedTransition}s in an {@link Automaton} guarded with a {@link NOT}
   * operator.
   */
  private final BatchTransformationRule<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher> notUnfoldRule = new Function0<BatchTransformationRule<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher>>() {
    public BatchTransformationRule<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher>createRule();
        IQuerySpecification<NonUnfoldedNotTransitionMatcher> _querySpecification = NonUnfoldedNotTransitionMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<NonUnfoldedNotTransitionMatch> _function = new IMatchProcessor<NonUnfoldedNotTransitionMatch>() {
          @Override
          public void process(final NonUnfoldedNotTransitionMatch it) {
            ComplexEventPattern _eventPattern = it.getEventPattern();
            EList<EventPatternReference> _containedEventPatterns = _eventPattern.getContainedEventPatterns();
            int _size = _containedEventPatterns.size();
            boolean _equals = (_size == 1);
            Preconditions.checkArgument(_equals);
            Automaton _automaton = it.getAutomaton();
            ComplexEventPattern _eventPattern_1 = it.getEventPattern();
            EList<EventPatternReference> _containedEventPatterns_1 = _eventPattern_1.getContainedEventPatterns();
            EventPatternReference _head = IterableExtensions.<EventPatternReference>head(_containedEventPatterns_1);
            EventPattern _eventPattern_2 = _head.getEventPattern();
            TypedTransition _transition = it.getTransition();
            State _preState = _transition.getPreState();
            TypedTransition _transition_1 = it.getTransition();
            State _postState = _transition_1.getPostState();
            ComplexMappingRules.this.complexMappingUtils.buildNotPath(_automaton, _eventPattern_2, _preState, _postState);
            TypedTransition _transition_2 = it.getTransition();
            ComplexMappingRules.this.builderPrimitives.removeTransition(_transition_2);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<NonUnfoldedNotTransitionMatch, NonUnfoldedNotTransitionMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to unfold {@link NegativeTransition}s in an {@link Automaton} guarded by a
   * {@link ComplexEventPattern}.
   */
  private final BatchTransformationRule<ComplexNotTransitionMatch, ComplexNotTransitionMatcher> negativeTransitionUnfoldRule = new Function0<BatchTransformationRule<ComplexNotTransitionMatch, ComplexNotTransitionMatcher>>() {
    public BatchTransformationRule<ComplexNotTransitionMatch, ComplexNotTransitionMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexNotTransitionMatch, ComplexNotTransitionMatcher> _createRule = ComplexMappingRules.this.ruleFactory.<ComplexNotTransitionMatch, ComplexNotTransitionMatcher>createRule();
        IQuerySpecification<ComplexNotTransitionMatcher> _querySpecification = ComplexNotTransitionMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexNotTransitionMatch, ComplexNotTransitionMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<ComplexNotTransitionMatch> _function = new IMatchProcessor<ComplexNotTransitionMatch>() {
          @Override
          public void process(final ComplexNotTransitionMatch it) {
            Automaton _automaton = it.getAutomaton();
            ComplexEventPattern _eventPattern = it.getEventPattern();
            TypedTransition _transition = it.getTransition();
            ComplexMappingRules.this.complexMappingUtils.unfoldNotPath(_automaton, _eventPattern, ((NegativeTransition) _transition));
            TypedTransition _transition_1 = it.getTransition();
            ComplexMappingRules.this.builderPrimitives.removeTransition(_transition_1);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<ComplexNotTransitionMatch, ComplexNotTransitionMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<ComplexNotTransitionMatch, ComplexNotTransitionMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
}
