/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.engine.compiler.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatch;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentTransitionsMatch;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentTransitionsMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.builders.BuilderPrimitives;
import org.eclipse.viatra.cep.core.engine.compiler.rules.MappingRules;
import org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition;
import org.eclipse.viatra.cep.core.metamodels.automaton.FinalState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.cep.core.metamodels.automaton.Parameter;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;
import org.eclipse.viatra.cep.core.metamodels.automaton.Transition;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.trace.TraceModel;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class OptimizationRules extends MappingRules {
  @Extension
  private BuilderPrimitives builderPrimitives;
  
  public OptimizationRules(final InternalModel internalModel, final TraceModel traceModel) {
    super(internalModel, traceModel);
    BuilderPrimitives _builderPrimitives = new BuilderPrimitives(traceModel);
    this.builderPrimitives = _builderPrimitives;
  }
  
  @Override
  public List<? extends BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>> getAllRules() {
    return Collections.<BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>>unmodifiableList(CollectionLiterals.<BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>>newArrayList(this.mergeUponEpsilonTransitionRule, this.mergeEquivalentTransitionsRule, this.mergeEquivalentStatesRule));
  }
  
  /**
   * Transformation rule to merge {@link State}s connected by an {@link EpsilonTransition}.
   */
  private final BatchTransformationRule<EpsilonTransitionMatch, EpsilonTransitionMatcher> mergeUponEpsilonTransitionRule = new Function0<BatchTransformationRule<EpsilonTransitionMatch, EpsilonTransitionMatcher>>() {
    public BatchTransformationRule<EpsilonTransitionMatch, EpsilonTransitionMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EpsilonTransitionMatch, EpsilonTransitionMatcher> _createRule = OptimizationRules.this.ruleFactory.<EpsilonTransitionMatch, EpsilonTransitionMatcher>createRule();
        IQuerySpecification<EpsilonTransitionMatcher> _querySpecification = EpsilonTransitionMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EpsilonTransitionMatch, EpsilonTransitionMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<EpsilonTransitionMatch> _function = new IMatchProcessor<EpsilonTransitionMatch>() {
          @Override
          public void process(final EpsilonTransitionMatch it) {
            State _preState = it.getPreState();
            if ((_preState instanceof InitState)) {
              State _preState_1 = it.getPreState();
              State _postState = it.getPostState();
              EpsilonTransition _transition = it.getTransition();
              OptimizationRules.this.mergeStates(((InitState) _preState_1), _postState, _transition);
            } else {
              State _postState_1 = it.getPostState();
              if ((_postState_1 instanceof FinalState)) {
                State _postState_2 = it.getPostState();
                State _preState_2 = it.getPreState();
                EpsilonTransition _transition_1 = it.getTransition();
                OptimizationRules.this.mergeStates(((FinalState) _postState_2), _preState_2, _transition_1);
              } else {
                State _preState_3 = it.getPreState();
                State _postState_3 = it.getPostState();
                EpsilonTransition _transition_2 = it.getTransition();
                OptimizationRules.this.mergeStates(_preState_3, _postState_3, _transition_2);
              }
            }
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EpsilonTransitionMatch, EpsilonTransitionMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<EpsilonTransitionMatch, EpsilonTransitionMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to merge equivalent {@link Transition}s.
   */
  private final BatchTransformationRule<EquivalentTransitionsMatch, EquivalentTransitionsMatcher> mergeEquivalentTransitionsRule = new Function0<BatchTransformationRule<EquivalentTransitionsMatch, EquivalentTransitionsMatcher>>() {
    public BatchTransformationRule<EquivalentTransitionsMatch, EquivalentTransitionsMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EquivalentTransitionsMatch, EquivalentTransitionsMatcher> _createRule = OptimizationRules.this.ruleFactory.<EquivalentTransitionsMatch, EquivalentTransitionsMatcher>createRule();
        IQuerySpecification<EquivalentTransitionsMatcher> _querySpecification = EquivalentTransitionsMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EquivalentTransitionsMatch, EquivalentTransitionsMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<EquivalentTransitionsMatch> _function = new IMatchProcessor<EquivalentTransitionsMatch>() {
          @Override
          public void process(final EquivalentTransitionsMatch it) {
            TypedTransition _transition2 = it.getTransition2();
            EList<Parameter> _parameters = _transition2.getParameters();
            TypedTransition _transition1 = it.getTransition1();
            EList<Parameter> _parameters_1 = _transition1.getParameters();
            Iterables.<Parameter>addAll(_parameters, _parameters_1);
            TypedTransition _transition1_1 = it.getTransition1();
            OptimizationRules.this.builderPrimitives.removeTransition(_transition1_1);
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EquivalentTransitionsMatch, EquivalentTransitionsMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<EquivalentTransitionsMatch, EquivalentTransitionsMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Transformation rule to merge equivalent {@link State}s.
   */
  private final BatchTransformationRule<EquivalentStatesMatch, EquivalentStatesMatcher> mergeEquivalentStatesRule = new Function0<BatchTransformationRule<EquivalentStatesMatch, EquivalentStatesMatcher>>() {
    public BatchTransformationRule<EquivalentStatesMatch, EquivalentStatesMatcher> apply() {
      try {
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EquivalentStatesMatch, EquivalentStatesMatcher> _createRule = OptimizationRules.this.ruleFactory.<EquivalentStatesMatch, EquivalentStatesMatcher>createRule();
        IQuerySpecification<EquivalentStatesMatcher> _querySpecification = EquivalentStatesMatcher.querySpecification();
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EquivalentStatesMatch, EquivalentStatesMatcher> _precondition = _createRule.precondition(_querySpecification);
        final IMatchProcessor<EquivalentStatesMatch> _function = new IMatchProcessor<EquivalentStatesMatch>() {
          @Override
          public void process(final EquivalentStatesMatch it) {
            boolean _and = false;
            State _postState1 = it.getPostState1();
            if (!(_postState1 instanceof InitState)) {
              _and = false;
            } else {
              State _postState2 = it.getPostState2();
              _and = (_postState2 instanceof FinalState);
            }
            boolean _not = (!_and);
            Preconditions.checkArgument(_not);
            boolean _and_1 = false;
            State _postState1_1 = it.getPostState1();
            if (!(_postState1_1 instanceof FinalState)) {
              _and_1 = false;
            } else {
              State _postState2_1 = it.getPostState2();
              _and_1 = (_postState2_1 instanceof InitState);
            }
            boolean _not_1 = (!_and_1);
            Preconditions.checkArgument(_not_1);
            State _postState1_2 = it.getPostState1();
            boolean _matched = false;
            if (!_matched) {
              if (_postState1_2 instanceof InitState) {
                _matched=true;
                State _postState1_3 = it.getPostState1();
                State _postState2_2 = it.getPostState2();
                TypedTransition _transition1 = it.getTransition1();
                TypedTransition _transition2 = it.getTransition2();
                OptimizationRules.this.mergeStates(_postState1_3, _postState2_2, _transition1, _transition2);
              }
            }
            if (!_matched) {
              if (_postState1_2 instanceof FinalState) {
                _matched=true;
                State _postState1_3 = it.getPostState1();
                State _postState2_2 = it.getPostState2();
                TypedTransition _transition1 = it.getTransition1();
                TypedTransition _transition2 = it.getTransition2();
                OptimizationRules.this.mergeStates(_postState1_3, _postState2_2, _transition1, _transition2);
              }
            }
            if (!_matched) {
              State _postState2_2 = it.getPostState2();
              boolean _matched_1 = false;
              if (!_matched_1) {
                if (_postState2_2 instanceof InitState) {
                  _matched_1=true;
                  State _postState2_3 = it.getPostState2();
                  State _postState1_3 = it.getPostState1();
                  TypedTransition _transition2 = it.getTransition2();
                  TypedTransition _transition1 = it.getTransition1();
                  OptimizationRules.this.mergeStates(_postState2_3, _postState1_3, _transition2, _transition1);
                }
              }
              if (!_matched_1) {
                if (_postState2_2 instanceof FinalState) {
                  _matched_1=true;
                  State _postState2_3 = it.getPostState2();
                  State _postState1_3 = it.getPostState1();
                  TypedTransition _transition2 = it.getTransition2();
                  TypedTransition _transition1 = it.getTransition1();
                  OptimizationRules.this.mergeStates(_postState2_3, _postState1_3, _transition2, _transition1);
                }
              }
              if (!_matched_1) {
                State _postState1_3 = it.getPostState1();
                State _postState2_3 = it.getPostState2();
                TypedTransition _transition1 = it.getTransition1();
                TypedTransition _transition2 = it.getTransition2();
                OptimizationRules.this.mergeStates(_postState1_3, _postState2_3, _transition1, _transition2);
              }
            }
          }
        };
        BatchTransformationRuleFactory.BatchTransformationRuleBuilder<EquivalentStatesMatch, EquivalentStatesMatcher> _action = _precondition.action(_function);
        BatchTransformationRule<EquivalentStatesMatch, EquivalentStatesMatcher> _build = _action.build();
        return _build;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
  
  /**
   * Merge a {@link State} into an {@link InitState} through a {@link Transition}.
   */
  private boolean mergeStates(final InitState stateToKeep, final State stateToDelete, final Transition transition) {
    return this.mergeStates(stateToDelete, stateToKeep, transition);
  }
  
  /**
   * Merge a {@link State} into an {@link FinalState} through a {@link Transition}.
   */
  private boolean mergeStates(final FinalState stateToKeep, final State stateToDelete, final Transition transition) {
    return this.mergeStates(stateToDelete, stateToKeep, transition);
  }
  
  /**
   * Merge two {@link State}s with the respective associated {@link Transition}s.
   */
  private boolean mergeStates(final State stateToDelete, final State stateToKeep, final TypedTransition transitionToRemove, final TypedTransition transitionToKeep) {
    boolean _xblockexpression = false;
    {
      EList<Parameter> _parameters = transitionToKeep.getParameters();
      EList<Parameter> _parameters_1 = transitionToRemove.getParameters();
      Iterables.<Parameter>addAll(_parameters, _parameters_1);
      _xblockexpression = this.mergeStates(stateToDelete, stateToKeep, transitionToRemove);
    }
    return _xblockexpression;
  }
  
  /**
   * Merge two {@link State}s through a {@link Transition}.
   */
  private boolean mergeStates(final State stateToDelete, final State stateToKeep, final Transition transition) {
    boolean _xblockexpression = false;
    {
      this.builderPrimitives.removeTransition(transition);
      _xblockexpression = this.mergeStates(stateToDelete, stateToKeep);
    }
    return _xblockexpression;
  }
  
  /**
   * Merge two {@link State}s.
   */
  private boolean mergeStates(final State stateToDelete, final State stateToKeep) {
    boolean _xblockexpression = false;
    {
      EList<Transition> _inTransitions = stateToKeep.getInTransitions();
      EList<Transition> _inTransitions_1 = stateToDelete.getInTransitions();
      Iterables.<Transition>addAll(_inTransitions, _inTransitions_1);
      EList<Transition> _outTransitions = stateToKeep.getOutTransitions();
      EList<Transition> _outTransitions_1 = stateToDelete.getOutTransitions();
      Iterables.<Transition>addAll(_outTransitions, _outTransitions_1);
      EList<TimedZone> _inStateOf = stateToKeep.getInStateOf();
      EList<TimedZone> _inStateOf_1 = stateToDelete.getInStateOf();
      Iterables.<TimedZone>addAll(_inStateOf, _inStateOf_1);
      EList<TimedZone> _outStateOf = stateToKeep.getOutStateOf();
      EList<TimedZone> _outStateOf_1 = stateToDelete.getOutStateOf();
      Iterables.<TimedZone>addAll(_outStateOf, _outStateOf_1);
      EList<Transition> _outTransitions_2 = stateToDelete.getOutTransitions();
      final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
        @Override
        public Boolean apply(final Transition t) {
          return Boolean.valueOf((t instanceof EpsilonTransition));
        }
      };
      boolean _forall = IterableExtensions.<Transition>forall(_outTransitions_2, _function);
      Preconditions.checkArgument(_forall);
      _xblockexpression = this.builderPrimitives.removeState(stateToDelete);
    }
    return _xblockexpression;
  }
}
