/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexNotTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate ComplexNotTransitionMatcher in a type-safe way.
 * 
 * @see ComplexNotTransitionMatcher
 * @see ComplexNotTransitionMatch
 * 
 */
@SuppressWarnings("all")
public final class ComplexNotTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<ComplexNotTransitionMatcher> {
  private ComplexNotTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static ComplexNotTransitionQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ComplexNotTransitionMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ComplexNotTransitionMatcher.on(engine);
  }
  
  @Override
  public ComplexNotTransitionMatcher instantiate() throws ViatraQueryException {
    return ComplexNotTransitionMatcher.create();
  }
  
  @Override
  public ComplexNotTransitionMatch newEmptyMatch() {
    return ComplexNotTransitionMatch.newEmptyMatch();
  }
  
  @Override
  public ComplexNotTransitionMatch newMatch(final Object... parameters) {
    return ComplexNotTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[1], (org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern) parameters[2]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link ComplexNotTransitionQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link ComplexNotTransitionQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static ComplexNotTransitionQuerySpecification INSTANCE = new ComplexNotTransitionQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ComplexNotTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pAutomaton = new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "Automaton")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTransition = new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TypedTransition")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pEventPattern = new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("cep.meta", "ComplexEventPattern")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pAutomaton, parameter_pTransition, parameter_pEventPattern);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.complexNotTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","transition","eventPattern");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, parameter_pAutomaton),
      		   new ExportedParameter(body, var_transition, parameter_pTransition),
      		   new ExportedParameter(body, var_eventPattern, parameter_pEventPattern)
      		));
      		// 	find complexTransition(automaton, transition, eventPattern, _)
      		new PositivePatternCall(body, new FlatTuple(var_automaton, var_transition, var_eventPattern, var___0_), ComplexTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	find negativeTransition(transition)
      		new PositivePatternCall(body, new FlatTuple(var_transition), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
