/**
 * 
 *   Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatch;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.SameBooleanTransitionTypeQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate EquivalentStatesMatcher in a type-safe way.
 * 
 * @see EquivalentStatesMatcher
 * @see EquivalentStatesMatch
 * 
 */
@SuppressWarnings("all")
public final class EquivalentStatesQuerySpecification extends BaseGeneratedEMFQuerySpecification<EquivalentStatesMatcher> {
  private EquivalentStatesQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryException if the pattern definition could not be loaded
   * 
   */
  public static EquivalentStatesQuerySpecification instance() throws ViatraQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected EquivalentStatesMatcher instantiate(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EquivalentStatesMatcher.on(engine);
  }
  
  @Override
  public EquivalentStatesMatcher instantiate() throws ViatraQueryException {
    return EquivalentStatesMatcher.create();
  }
  
  @Override
  public EquivalentStatesMatch newEmptyMatch() {
    return EquivalentStatesMatch.newEmptyMatch();
  }
  
  @Override
  public EquivalentStatesMatch newMatch(final Object... parameters) {
    return EquivalentStatesMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[1], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[2], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[3], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[4]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link EquivalentStatesQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link EquivalentStatesQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static EquivalentStatesQuerySpecification INSTANCE = new EquivalentStatesQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static EquivalentStatesQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_pTransition1 = new PParameter("transition1", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TypedTransition")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pTransition2 = new PParameter("transition2", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "TypedTransition")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pPreState = new PParameter("preState", "org.eclipse.viatra.cep.core.metamodels.automaton.State", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "State")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pPostState1 = new PParameter("postState1", "org.eclipse.viatra.cep.core.metamodels.automaton.State", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "State")), PParameterDirection.INOUT);
    
    private final PParameter parameter_pPostState2 = new PParameter("postState2", "org.eclipse.viatra.cep.core.metamodels.automaton.State", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("automaton.meta", "State")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_pTransition1, parameter_pTransition2, parameter_pPreState, parameter_pPostState1, parameter_pPostState2);
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.equivalentStates";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("transition1","transition2","preState","postState1","postState2");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      setEvaluationHints(new QueryEvaluationHint(null, Collections.<String,Object>emptyMap()));
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition1 = body.getOrCreateVariableByName("transition1");
      		PVariable var_transition2 = body.getOrCreateVariableByName("transition2");
      		PVariable var_preState = body.getOrCreateVariableByName("preState");
      		PVariable var_postState1 = body.getOrCreateVariableByName("postState1");
      		PVariable var_postState2 = body.getOrCreateVariableByName("postState2");
      		PVariable var_guard1 = body.getOrCreateVariableByName("guard1");
      		PVariable var_guard2 = body.getOrCreateVariableByName("guard2");
      		PVariable var_et1 = body.getOrCreateVariableByName("et1");
      		PVariable var_et2 = body.getOrCreateVariableByName("et2");
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_postState1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_postState2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition1, parameter_pTransition1),
      		   new ExportedParameter(body, var_transition2, parameter_pTransition2),
      		   new ExportedParameter(body, var_preState, parameter_pPreState),
      		   new ExportedParameter(body, var_postState1, parameter_pPostState1),
      		   new ExportedParameter(body, var_postState2, parameter_pPostState2)
      		));
      		// 	transition1 != transition2
      		new Inequality(body, var_transition1, var_transition2);
      		// 		find sameBooleanTransitionType(transition1, transition2)
      		new PositivePatternCall(body, new FlatTuple(var_transition1, var_transition2), SameBooleanTransitionTypeQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	Transition.preState(transition1, preState)
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_transition1, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "preState")));
      		new Equality(body, var__virtual_0_, var_preState);
      		// 	Transition.preState(transition2, preState)
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_transition2, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "preState")));
      		new Equality(body, var__virtual_1_, var_preState);
      		// 	Transition.postState(transition1, postState1)
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_transition1, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "postState")));
      		new Equality(body, var__virtual_2_, var_postState1);
      		// 	Transition.postState(transition2, postState2)
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_transition2, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "postState")));
      		new Equality(body, var__virtual_3_, var_postState2);
      		// 	postState1 != postState2
      		new Inequality(body, var_postState1, var_postState2);
      		// 	TypedTransition.guards(transition1, guard1)
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_transition1, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		new Equality(body, var__virtual_4_, var_guard1);
      		// 	TypedTransition.guards(transition2, guard2)
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_5_ = body.getOrCreateVariableByName(".virtual{5}");
      		new TypeConstraint(body, new FlatTuple(var_transition2, var__virtual_5_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		new Equality(body, var__virtual_5_, var_guard2);
      		// 	Guard.eventType(guard1, et1)
      		new TypeConstraint(body, new FlatTuple(var_guard1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Guard")));
      		PVariable var__virtual_6_ = body.getOrCreateVariableByName(".virtual{6}");
      		new TypeConstraint(body, new FlatTuple(var_guard1, var__virtual_6_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_6_, var_et1);
      		// 	Guard.eventType(guard2, et2)
      		new TypeConstraint(body, new FlatTuple(var_guard2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Guard")));
      		PVariable var__virtual_7_ = body.getOrCreateVariableByName(".virtual{7}");
      		new TypeConstraint(body, new FlatTuple(var_guard2, var__virtual_7_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_7_, var_et2);
      		// 	et1 == et2
      		new Equality(body, var_et1, var_et2);
      		// 	Automaton.states(automaton, preState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_8_ = body.getOrCreateVariableByName(".virtual{8}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_8_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_8_, var_preState);
      		// 	Automaton.states(automaton, postState1)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_9_ = body.getOrCreateVariableByName(".virtual{9}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_9_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_9_, var_postState1);
      		// 	Automaton.states(automaton, postState2)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_10_ = body.getOrCreateVariableByName(".virtual{10}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_10_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_10_, var_postState2);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new ViatraQueryException("Never", "happens");
      } catch (ViatraQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
