/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import org.eclipse.viatra.cep.core.engine.runtime.EnabledNegativeTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.EnabledTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.EventProcessedByEventTokenMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.FinishedAutomatonMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.InitStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.LatestEventMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.NegativeTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.PartiallyMatchedEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenEntersTimedZoneMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInFinalStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInInitStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInTimedZoneMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInTrapStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenLeavesTimedZoneMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TransitionWithEventTypeMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.util.EnabledNegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.EnabledTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.EventProcessedByEventTokenQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.FinishedAutomatonQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.InitStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.LatestEventQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.PartiallyMatchedEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.ResettableEventTokenQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenEntersTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInFinalStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInInitStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInTrapStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenLeavesTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TransitionWithEventTypeQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * A pattern group formed of all patterns defined in runtimePatterns.vql.
 * 
 * <p>Use the static instance as any {@link org.eclipse.viatra.query.runtime.api.IPatternGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file runtimePatterns.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.cep.core.engine.runtime, the group contains the definition of the following patterns: <ul>
 * <li>latestEvent</li>
 * <li>finishedAutomaton</li>
 * <li>tokenInTrapState</li>
 * <li>tokenInInitState</li>
 * <li>tokenInFinalState</li>
 * <li>resettableEventToken</li>
 * <li>enabledTransition</li>
 * <li>enabledNegativeTransition</li>
 * <li>transitionWithEventType</li>
 * <li>negativeTransition</li>
 * <li>eventProcessedByEventToken</li>
 * <li>partiallyMatchedEventPattern</li>
 * <li>initState</li>
 * <li>tokenEntersTimedZone</li>
 * <li>tokenLeavesTimedZone</li>
 * <li>tokenInTimedZone</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class RuntimePatterns extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static RuntimePatterns instance() throws ViatraQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new RuntimePatterns();
    }
    return INSTANCE;
  }
  
  private static RuntimePatterns INSTANCE;
  
  private RuntimePatterns() throws ViatraQueryException {
    querySpecifications.add(LatestEventQuerySpecification.instance());
    querySpecifications.add(FinishedAutomatonQuerySpecification.instance());
    querySpecifications.add(TokenInTrapStateQuerySpecification.instance());
    querySpecifications.add(TokenInInitStateQuerySpecification.instance());
    querySpecifications.add(TokenInFinalStateQuerySpecification.instance());
    querySpecifications.add(ResettableEventTokenQuerySpecification.instance());
    querySpecifications.add(EnabledTransitionQuerySpecification.instance());
    querySpecifications.add(EnabledNegativeTransitionQuerySpecification.instance());
    querySpecifications.add(TransitionWithEventTypeQuerySpecification.instance());
    querySpecifications.add(NegativeTransitionQuerySpecification.instance());
    querySpecifications.add(EventProcessedByEventTokenQuerySpecification.instance());
    querySpecifications.add(PartiallyMatchedEventPatternQuerySpecification.instance());
    querySpecifications.add(InitStateQuerySpecification.instance());
    querySpecifications.add(TokenEntersTimedZoneQuerySpecification.instance());
    querySpecifications.add(TokenLeavesTimedZoneQuerySpecification.instance());
    querySpecifications.add(TokenInTimedZoneQuerySpecification.instance());
  }
  
  public LatestEventQuerySpecification getLatestEvent() throws ViatraQueryException {
    return LatestEventQuerySpecification.instance();
  }
  
  public LatestEventMatcher getLatestEvent(final ViatraQueryEngine engine) throws ViatraQueryException {
    return LatestEventMatcher.on(engine);
  }
  
  public FinishedAutomatonQuerySpecification getFinishedAutomaton() throws ViatraQueryException {
    return FinishedAutomatonQuerySpecification.instance();
  }
  
  public FinishedAutomatonMatcher getFinishedAutomaton(final ViatraQueryEngine engine) throws ViatraQueryException {
    return FinishedAutomatonMatcher.on(engine);
  }
  
  public TokenInTrapStateQuerySpecification getTokenInTrapState() throws ViatraQueryException {
    return TokenInTrapStateQuerySpecification.instance();
  }
  
  public TokenInTrapStateMatcher getTokenInTrapState(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TokenInTrapStateMatcher.on(engine);
  }
  
  public TokenInInitStateQuerySpecification getTokenInInitState() throws ViatraQueryException {
    return TokenInInitStateQuerySpecification.instance();
  }
  
  public TokenInInitStateMatcher getTokenInInitState(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TokenInInitStateMatcher.on(engine);
  }
  
  public TokenInFinalStateQuerySpecification getTokenInFinalState() throws ViatraQueryException {
    return TokenInFinalStateQuerySpecification.instance();
  }
  
  public TokenInFinalStateMatcher getTokenInFinalState(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TokenInFinalStateMatcher.on(engine);
  }
  
  public ResettableEventTokenQuerySpecification getResettableEventToken() throws ViatraQueryException {
    return ResettableEventTokenQuerySpecification.instance();
  }
  
  public ResettableEventTokenMatcher getResettableEventToken(final ViatraQueryEngine engine) throws ViatraQueryException {
    return ResettableEventTokenMatcher.on(engine);
  }
  
  public EnabledTransitionQuerySpecification getEnabledTransition() throws ViatraQueryException {
    return EnabledTransitionQuerySpecification.instance();
  }
  
  public EnabledTransitionMatcher getEnabledTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EnabledTransitionMatcher.on(engine);
  }
  
  public EnabledNegativeTransitionQuerySpecification getEnabledNegativeTransition() throws ViatraQueryException {
    return EnabledNegativeTransitionQuerySpecification.instance();
  }
  
  public EnabledNegativeTransitionMatcher getEnabledNegativeTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EnabledNegativeTransitionMatcher.on(engine);
  }
  
  public TransitionWithEventTypeQuerySpecification getTransitionWithEventType() throws ViatraQueryException {
    return TransitionWithEventTypeQuerySpecification.instance();
  }
  
  public TransitionWithEventTypeMatcher getTransitionWithEventType(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TransitionWithEventTypeMatcher.on(engine);
  }
  
  public NegativeTransitionQuerySpecification getNegativeTransition() throws ViatraQueryException {
    return NegativeTransitionQuerySpecification.instance();
  }
  
  public NegativeTransitionMatcher getNegativeTransition(final ViatraQueryEngine engine) throws ViatraQueryException {
    return NegativeTransitionMatcher.on(engine);
  }
  
  public EventProcessedByEventTokenQuerySpecification getEventProcessedByEventToken() throws ViatraQueryException {
    return EventProcessedByEventTokenQuerySpecification.instance();
  }
  
  public EventProcessedByEventTokenMatcher getEventProcessedByEventToken(final ViatraQueryEngine engine) throws ViatraQueryException {
    return EventProcessedByEventTokenMatcher.on(engine);
  }
  
  public PartiallyMatchedEventPatternQuerySpecification getPartiallyMatchedEventPattern() throws ViatraQueryException {
    return PartiallyMatchedEventPatternQuerySpecification.instance();
  }
  
  public PartiallyMatchedEventPatternMatcher getPartiallyMatchedEventPattern(final ViatraQueryEngine engine) throws ViatraQueryException {
    return PartiallyMatchedEventPatternMatcher.on(engine);
  }
  
  public InitStateQuerySpecification getInitState() throws ViatraQueryException {
    return InitStateQuerySpecification.instance();
  }
  
  public InitStateMatcher getInitState(final ViatraQueryEngine engine) throws ViatraQueryException {
    return InitStateMatcher.on(engine);
  }
  
  public TokenEntersTimedZoneQuerySpecification getTokenEntersTimedZone() throws ViatraQueryException {
    return TokenEntersTimedZoneQuerySpecification.instance();
  }
  
  public TokenEntersTimedZoneMatcher getTokenEntersTimedZone(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TokenEntersTimedZoneMatcher.on(engine);
  }
  
  public TokenLeavesTimedZoneQuerySpecification getTokenLeavesTimedZone() throws ViatraQueryException {
    return TokenLeavesTimedZoneQuerySpecification.instance();
  }
  
  public TokenLeavesTimedZoneMatcher getTokenLeavesTimedZone(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TokenLeavesTimedZoneMatcher.on(engine);
  }
  
  public TokenInTimedZoneQuerySpecification getTokenInTimedZone() throws ViatraQueryException {
    return TokenInTimedZoneQuerySpecification.instance();
  }
  
  public TokenInTimedZoneMatcher getTokenInTimedZone(final ViatraQueryEngine engine) throws ViatraQueryException {
    return TokenInTimedZoneMatcher.on(engine);
  }
}
