/**
 * 
 *   Copyright (c) 2004-2014, Istvan David, Istvan Rath and Daniel Varro
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *   Istvan David - initial API and implementation
 *  
 */
package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.tokenInTimedZone pattern,
 * to be used in conjunction with {@link TokenInTimedZoneMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see TokenInTimedZoneMatcher
 * @see TokenInTimedZoneProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class TokenInTimedZoneMatch extends BasePatternMatch {
  private EventToken fEventToken;
  
  private State fState;
  
  private TimedZone fTimedZone;
  
  private static List<String> parameterNames = makeImmutableList("eventToken", "state", "timedZone");
  
  private TokenInTimedZoneMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    this.fEventToken = pEventToken;
    this.fState = pState;
    this.fTimedZone = pTimedZone;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("eventToken".equals(parameterName)) return this.fEventToken;
    if ("state".equals(parameterName)) return this.fState;
    if ("timedZone".equals(parameterName)) return this.fTimedZone;
    return null;
  }
  
  public EventToken getEventToken() {
    return this.fEventToken;
  }
  
  public State getState() {
    return this.fState;
  }
  
  public TimedZone getTimedZone() {
    return this.fTimedZone;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("eventToken".equals(parameterName) ) {
    	this.fEventToken = (EventToken) newValue;
    	return true;
    }
    if ("state".equals(parameterName) ) {
    	this.fState = (State) newValue;
    	return true;
    }
    if ("timedZone".equals(parameterName) ) {
    	this.fTimedZone = (TimedZone) newValue;
    	return true;
    }
    return false;
  }
  
  public void setEventToken(final EventToken pEventToken) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventToken = pEventToken;
  }
  
  public void setState(final State pState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fState = pState;
  }
  
  public void setTimedZone(final TimedZone pTimedZone) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTimedZone = pTimedZone;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.tokenInTimedZone";
  }
  
  @Override
  public List<String> parameterNames() {
    return TokenInTimedZoneMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fEventToken, fState, fTimedZone};
  }
  
  @Override
  public TokenInTimedZoneMatch toImmutable() {
    return isMutable() ? newMatch(fEventToken, fState, fTimedZone) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"eventToken\"=" + prettyPrintValue(fEventToken) + ", ");
    
    result.append("\"state\"=" + prettyPrintValue(fState) + ", ");
    
    result.append("\"timedZone\"=" + prettyPrintValue(fTimedZone)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fEventToken == null) ? 0 : fEventToken.hashCode());
    result = prime * result + ((fState == null) ? 0 : fState.hashCode());
    result = prime * result + ((fTimedZone == null) ? 0 : fTimedZone.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof TokenInTimedZoneMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    TokenInTimedZoneMatch other = (TokenInTimedZoneMatch) obj;
    if (fEventToken == null) {if (other.fEventToken != null) return false;}
    else if (!fEventToken.equals(other.fEventToken)) return false;
    if (fState == null) {if (other.fState != null) return false;}
    else if (!fState.equals(other.fState)) return false;
    if (fTimedZone == null) {if (other.fTimedZone != null) return false;}
    else if (!fTimedZone.equals(other.fTimedZone)) return false;
    return true;
  }
  
  @Override
  public TokenInTimedZoneQuerySpecification specification() {
    try {
    	return TokenInTimedZoneQuerySpecification.instance();
    } catch (ViatraQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static TokenInTimedZoneMatch newEmptyMatch() {
    return new Mutable(null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static TokenInTimedZoneMatch newMutableMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return new Mutable(pEventToken, pState, pTimedZone);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static TokenInTimedZoneMatch newMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return new Immutable(pEventToken, pState, pTimedZone);
  }
  
  private static final class Mutable extends TokenInTimedZoneMatch {
    Mutable(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
      super(pEventToken, pState, pTimedZone);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends TokenInTimedZoneMatch {
    Immutable(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
      super(pEventToken, pState, pTimedZone);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
